/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.demeterf.util;

import edu.neu.ccs.demeterf.demfgen.lib.List;
import edu.neu.ccs.demeterf.demfgen.lib.ident;
import edu.neu.ccs.demeterf.demfgen.lib.verbatim;
import edu.neu.ccs.demeterf.dispatch.DBEntry;
import edu.neu.ccs.demeterf.dispatch.MethodDB;
import edu.neu.ccs.demeterf.dispatch.Type;
import edu.neu.ccs.demeterf.util.Option;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;

public class Util {
    static boolean debugOn = false;
    static boolean warningOn = false;
    public static boolean allowNull = false;
    public static boolean skipPrivate = true;
    public static ArrayList<Class> builtIns = new ArrayList();
    public static Class<?>[] builtInArray;
    static HashMap<Class<?>, Class<?>> unboxed;
    static HashMap<Class<?>, Class<?>> boxed;
    public static int ARGS;
    public static int OPTS;

    static {
        Class<?>[] classArray = builtInArray = new Class[]{Short.TYPE, Short.class, Integer.class, Integer.TYPE, Float.class, Float.TYPE, Long.class, Long.TYPE, Double.class, Double.TYPE, String.class, Boolean.class, Boolean.TYPE, Character.TYPE, Character.class, ident.class, verbatim.class};
        int n2 = 0;
        int n3 = classArray.length;
        while (n2 < n3) {
            Class<?> clazz = classArray[n2];
            builtIns.add(clazz);
            ++n2;
        }
        unboxed = new HashMap();
        unboxed.put(Short.TYPE, Short.class);
        unboxed.put(Integer.TYPE, Integer.class);
        unboxed.put(Long.TYPE, Long.class);
        unboxed.put(Float.TYPE, Float.class);
        unboxed.put(Double.TYPE, Double.class);
        unboxed.put(Character.TYPE, Character.class);
        unboxed.put(Byte.TYPE, Byte.class);
        unboxed.put(Boolean.TYPE, Boolean.class);
        boxed = new HashMap();
        boxed.put(Short.class, Short.TYPE);
        boxed.put(Integer.class, Integer.TYPE);
        boxed.put(Long.class, Long.TYPE);
        boxed.put(Float.class, Float.TYPE);
        boxed.put(Double.class, Double.TYPE);
        boxed.put(Character.class, Character.TYPE);
        boxed.put(Byte.class, Byte.TYPE);
        boxed.put(Boolean.class, Boolean.TYPE);
        ARGS = 0;
        OPTS = 1;
    }

    private Util() {
    }

    public static boolean setDebug(boolean bl) {
        debugOn = bl;
        return debugOn;
    }

    public static boolean setWarning(boolean bl) {
        warningOn = bl;
        return warningOn;
    }

    public static boolean setAllowNull(boolean bl) {
        allowNull = bl;
        return allowNull;
    }

    public static boolean setSkipPrivate(boolean bl) {
        skipPrivate = bl;
        return skipPrivate;
    }

    public static void print(String string) {
        if (debugOn) {
            System.out.print(string);
        }
    }

    public static void println(String string) {
        Util.print(String.valueOf(string) + "\n");
    }

    public static boolean isBuiltIn(Class<?> clazz) {
        return builtIns.indexOf(clazz) >= 0;
    }

    public static void addBuiltIn(Class<?> clazz) {
        builtIns.add(clazz);
    }

    public static void addBuiltIns(Class<?> ... classArray) {
        Class<?>[] classArray2 = classArray;
        int n2 = 0;
        int n3 = classArray2.length;
        while (n2 < n3) {
            Class<?> clazz = classArray2[n2];
            builtIns.add(clazz);
            ++n2;
        }
    }

    public static java.util.List<Field> getFields(Class<?> clazz) {
        ArrayList<Field> arrayList = new ArrayList<Field>();
        while (clazz != null && !clazz.isPrimitive()) {
            Field[] fieldArray = clazz.getDeclaredFields();
            int n2 = 0;
            int n3 = fieldArray.length;
            while (n2 < n3) {
                Field field = fieldArray[n2];
                int n4 = field.getModifiers();
                if (!(Modifier.isStatic(n4) || skipPrivate && Modifier.isPrivate(n4))) {
                    arrayList.add(field);
                }
                ++n2;
            }
            clazz = clazz.getSuperclass();
        }
        return arrayList;
    }

    public static int numFields(Class<?> clazz) {
        int n2 = 0;
        while (clazz != null && !clazz.isPrimitive()) {
            Field[] fieldArray = clazz.getDeclaredFields();
            int n3 = 0;
            int n4 = fieldArray.length;
            while (n3 < n4) {
                Field field = fieldArray[n3];
                if (!Modifier.isStatic(field.getModifiers())) {
                    ++n2;
                }
                ++n3;
            }
            clazz = clazz.getSuperclass();
        }
        return n2;
    }

    public static Field getField(java.util.List<Field> list, int n2) {
        Field field = list.get(n2);
        field.setAccessible(true);
        return field;
    }

    public static Object[] addArg(Object[] objectArray, Option option) {
        Object[] objectArray2 = objectArray;
        if (option.some()) {
            objectArray2 = new Object[objectArray.length + 1];
            int n2 = 0;
            while (n2 < objectArray.length) {
                objectArray2[n2] = objectArray[n2];
                ++n2;
            }
            objectArray2[n2] = option.get();
        }
        return objectArray2;
    }

    public static Object applyFObj(Object object, Object[] objectArray, MethodDB<Method> methodDB, String string, int n2) {
        Class<?>[] classArray = Util.classesFromObjects(objectArray, objectArray.length);
        List<DBEntry<Method>> list = methodDB.matchEntrys(Type.fromClassArray(classArray, true));
        if (list.isEmpty()) {
            if (n2 < 0) {
                throw new RuntimeException("\n  DemeterF: Did Not Find a Match for: \n      " + Util.signature(object.getClass(), string, objectArray, objectArray.length) + "\n");
            }
            return objectArray[n2];
        }
        Util.checkWarnMethods(list, object.getClass());
        Method method = list.lookup(0).getMethod();
        Util.println(Util.signature(method));
        Object object2 = n2 >= 0 ? objectArray[n2] : null;
        try {
            method.setAccessible(true);
            object2 = method.invoke(object, Util.objectSubset(objectArray, method.getParameterTypes().length));
        }
        catch (IllegalAccessError illegalAccessError) {
            illegalAccessError.printStackTrace();
            throw new RuntimeException(illegalAccessError);
        }
        catch (InvocationTargetException invocationTargetException) {
            if (!(invocationTargetException.getTargetException() instanceof RuntimeException)) {
                invocationTargetException.getTargetException().printStackTrace();
            }
            throw (RuntimeException)invocationTargetException.getCause();
        }
        catch (Exception exception) {}
        return object2;
    }

    static void checkWarnMethods(List<DBEntry<Method>> list, Class clazz) {
        if (!warningOn) {
            return;
        }
        DBEntry<Method> dBEntry = list.top();
        while (!(list = list.pop()).isEmpty()) {
            DBEntry<Method> dBEntry2 = list.top();
            if (dBEntry2.numArgs() >= dBEntry.numArgs() || dBEntry2.numArgs() <= 0 || !dBEntry.arg(0).isAssignableFrom(dBEntry2.arg(0)) || dBEntry.arg(0).equals(dBEntry2.arg(0))) continue;
            System.err.println("\n %% DemeterF Warning: A method with more arguments has been\n      chosen instead of one with a more specific first argument\n  function class: " + clazz.getSimpleName() + "\n" + "  * Chose : " + Util.dbEntrySig(dBEntry) + "\n" + "  *   Not : " + Util.dbEntrySig(dBEntry2) + "\n");
            return;
        }
    }

    static String dbEntrySig(DBEntry<?> dBEntry) {
        return dBEntry.toString();
    }

    public static Class<?>[] classesFromObjects(Object[] objectArray, int n2) {
        Class[] classArray = new Class[n2];
        int n3 = 0;
        while (n3 < n2) {
            if (objectArray[n3] == null) {
                if (allowNull) {
                    classArray[n3] = null;
                } else {
                    Util.nullError();
                }
            } else {
                classArray[n3] = objectArray[n3].getClass();
            }
            ++n3;
        }
        return classArray;
    }

    public static Object[] objectSubset(Object[] objectArray, int n2) {
        Object[] objectArray2 = new Object[n2];
        int n3 = 0;
        while (n3 < n2) {
            objectArray2[n3] = objectArray[n3];
            ++n3;
        }
        return objectArray2;
    }

    public static String signature(Method method) {
        return Util.signature(method.getDeclaringClass(), method.getName(), method.getParameterTypes(), method.getParameterTypes().length);
    }

    public static String signature(Constructor<?> constructor) {
        return Util.signature(constructor.getDeclaringClass(), constructor.getDeclaringClass().getSimpleName(), constructor.getParameterTypes(), constructor.getParameterTypes().length);
    }

    public static String signature(Class<?> clazz, String string, Object[] objectArray, int n2) {
        return Util.signature(clazz, string, Util.classesFromObjects(objectArray, n2), n2);
    }

    public static String signature(Class<?> clazz, String string, Class<?>[] classArray, int n2) {
        String[] stringArray = new String[classArray.length];
        int n3 = 0;
        while (n3 < n2) {
            stringArray[n3] = classArray[n3].getSimpleName();
            ++n3;
        }
        return Util.signature(clazz, string, stringArray, n2);
    }

    public static String signature(Class<?> clazz, String string, String[] stringArray, int n2) {
        String string2 = String.valueOf(clazz.getSimpleName()) + "." + string + "(";
        int n3 = 0;
        while (n3 < n2) {
            string2 = String.valueOf(string2) + (stringArray == null ? "null" : stringArray[n3]);
            if (n3 < n2 - 1) {
                string2 = String.valueOf(string2) + ", ";
            }
            ++n3;
        }
        return String.valueOf(string2) + ")";
    }

    public static String signature(Class<?> clazz, String string, Type[] typeArray, int n2) {
        String[] stringArray = new String[typeArray.length];
        int n3 = 0;
        while (n3 < n2) {
            stringArray[n3] = typeArray[n3].unboxedType().getSimpleName();
            ++n3;
        }
        return Util.signature(clazz, string, stringArray, n2);
    }

    public static void nullError() {
        throw new RuntimeException("\n  DemeterF: Null Object Found\n");
    }

    public static void nullFieldError(Field field) {
        throw new RuntimeException("\n  DemeterF: Null Field Found:  " + field.getDeclaringClass().getSimpleName() + "." + field.getName() + "\n");
    }

    public static Class<?> box(Class<?> clazz) {
        if (clazz.isPrimitive()) {
            return unboxed.get(clazz);
        }
        return clazz;
    }

    public static Class<?> unbox(Class<?> clazz) {
        if (boxed.containsKey(clazz)) {
            return boxed.get(clazz);
        }
        return clazz;
    }

    public static List<String>[] splitArgs(String[] stringArray) {
        List<String> list = List.create(new String[0]);
        List[] listArray = new List[]{list, list};
        String[] stringArray2 = stringArray;
        int n2 = 0;
        int n3 = stringArray2.length;
        while (n2 < n3) {
            String string = stringArray2[n2];
            if (string.startsWith("-")) {
                listArray[Util.OPTS] = listArray[OPTS].push(string);
            } else {
                listArray[Util.ARGS] = listArray[ARGS].push(string);
            }
            ++n2;
        }
        listArray[Util.ARGS] = listArray[ARGS].reverse();
        return listArray;
    }

    public static String[] separateOption(String string, List<String> list) {
        final String string2 = "--" + string + ":";
        int n2 = list.index(new List.Pred<String>(){

            @Override
            public boolean huh(String string) {
                return string.startsWith(string2);
            }
        });
        if (n2 >= 0) {
            return list.lookup(n2).substring(string2.length()).split(":");
        }
        return new String[0];
    }
}

