/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.demeterf.typecheck.classes;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;

public class SimpleCharStream {
    public static final boolean staticFlag = false;
    int bufsize;
    int available;
    int tokenBegin;
    public int bufpos = -1;
    protected int[] bufline;
    protected int[] bufcolumn;
    protected int column = 0;
    protected int line = 1;
    protected boolean prevCharIsCR = false;
    protected boolean prevCharIsLF = false;
    protected Reader inputStream;
    protected char[] buffer;
    protected int maxNextCharInd = 0;
    protected int inBuf = 0;
    protected int tabSize = 8;

    protected void setTabSize(int n2) {
        this.tabSize = n2;
    }

    protected int getTabSize(int n2) {
        return this.tabSize;
    }

    protected void ExpandBuff(boolean bl) {
        char[] cArray = new char[this.bufsize + 2048];
        int[] nArray = new int[this.bufsize + 2048];
        int[] nArray2 = new int[this.bufsize + 2048];
        try {
            if (bl) {
                System.arraycopy(this.buffer, this.tokenBegin, cArray, 0, this.bufsize - this.tokenBegin);
                System.arraycopy(this.buffer, 0, cArray, this.bufsize - this.tokenBegin, this.bufpos);
                this.buffer = cArray;
                System.arraycopy(this.bufline, this.tokenBegin, nArray, 0, this.bufsize - this.tokenBegin);
                System.arraycopy(this.bufline, 0, nArray, this.bufsize - this.tokenBegin, this.bufpos);
                this.bufline = nArray;
                System.arraycopy(this.bufcolumn, this.tokenBegin, nArray2, 0, this.bufsize - this.tokenBegin);
                System.arraycopy(this.bufcolumn, 0, nArray2, this.bufsize - this.tokenBegin, this.bufpos);
                this.bufcolumn = nArray2;
                this.maxNextCharInd = this.bufpos += this.bufsize - this.tokenBegin;
            } else {
                System.arraycopy(this.buffer, this.tokenBegin, cArray, 0, this.bufsize - this.tokenBegin);
                this.buffer = cArray;
                System.arraycopy(this.bufline, this.tokenBegin, nArray, 0, this.bufsize - this.tokenBegin);
                this.bufline = nArray;
                System.arraycopy(this.bufcolumn, this.tokenBegin, nArray2, 0, this.bufsize - this.tokenBegin);
                this.bufcolumn = nArray2;
                this.maxNextCharInd = this.bufpos -= this.tokenBegin;
            }
        }
        catch (Throwable throwable) {
            throw new Error(throwable.getMessage());
        }
        this.bufsize += 2048;
        this.available = this.bufsize;
        this.tokenBegin = 0;
    }

    protected void FillBuff() throws IOException {
        if (this.maxNextCharInd == this.available) {
            if (this.available == this.bufsize) {
                if (this.tokenBegin > 2048) {
                    this.maxNextCharInd = 0;
                    this.bufpos = 0;
                    this.available = this.tokenBegin;
                } else if (this.tokenBegin < 0) {
                    this.maxNextCharInd = 0;
                    this.bufpos = 0;
                } else {
                    this.ExpandBuff(false);
                }
            } else if (this.available > this.tokenBegin) {
                this.available = this.bufsize;
            } else if (this.tokenBegin - this.available < 2048) {
                this.ExpandBuff(true);
            } else {
                this.available = this.tokenBegin;
            }
        }
        try {
            int n2 = this.inputStream.read(this.buffer, this.maxNextCharInd, this.available - this.maxNextCharInd);
            if (n2 == -1) {
                this.inputStream.close();
                throw new IOException();
            }
            this.maxNextCharInd += n2;
            return;
        }
        catch (IOException iOException) {
            --this.bufpos;
            this.backup(0);
            if (this.tokenBegin == -1) {
                this.tokenBegin = this.bufpos;
            }
            throw iOException;
        }
    }

    public char BeginToken() throws IOException {
        this.tokenBegin = -1;
        char c = this.readChar();
        this.tokenBegin = this.bufpos;
        return c;
    }

    protected void UpdateLineColumn(char c) {
        ++this.column;
        if (this.prevCharIsLF) {
            this.prevCharIsLF = false;
            this.column = 1;
            ++this.line;
        } else if (this.prevCharIsCR) {
            this.prevCharIsCR = false;
            if (c == '\n') {
                this.prevCharIsLF = true;
            } else {
                this.column = 1;
                ++this.line;
            }
        }
        switch (c) {
            case '\r': {
                this.prevCharIsCR = true;
                break;
            }
            case '\n': {
                this.prevCharIsLF = true;
                break;
            }
            case '\t': {
                --this.column;
                this.column += this.tabSize - this.column % this.tabSize;
                break;
            }
        }
        this.bufline[this.bufpos] = this.line;
        this.bufcolumn[this.bufpos] = this.column;
    }

    public char readChar() throws IOException {
        if (this.inBuf > 0) {
            --this.inBuf;
            if (++this.bufpos == this.bufsize) {
                this.bufpos = 0;
            }
            return this.buffer[this.bufpos];
        }
        if (++this.bufpos >= this.maxNextCharInd) {
            this.FillBuff();
        }
        char c = this.buffer[this.bufpos];
        this.UpdateLineColumn(c);
        return c;
    }

    public int getColumn() {
        return this.bufcolumn[this.bufpos];
    }

    public int getLine() {
        return this.bufline[this.bufpos];
    }

    public int getEndColumn() {
        return this.bufcolumn[this.bufpos];
    }

    public int getEndLine() {
        return this.bufline[this.bufpos];
    }

    public int getBeginColumn() {
        return this.bufcolumn[this.tokenBegin];
    }

    public int getBeginLine() {
        return this.bufline[this.tokenBegin];
    }

    public void backup(int n2) {
        this.inBuf += n2;
        if ((this.bufpos -= n2) < 0) {
            this.bufpos += this.bufsize;
        }
    }

    public SimpleCharStream(Reader reader, int n2, int n3, int n4) {
        this.inputStream = reader;
        this.line = n2;
        this.column = n3 - 1;
        this.available = this.bufsize = n4;
        this.buffer = new char[n4];
        this.bufline = new int[n4];
        this.bufcolumn = new int[n4];
    }

    public SimpleCharStream(Reader reader, int n2, int n3) {
        this(reader, n2, n3, 4096);
    }

    public SimpleCharStream(Reader reader) {
        this(reader, 1, 1, 4096);
    }

    public void ReInit(Reader reader, int n2, int n3, int n4) {
        this.inputStream = reader;
        this.line = n2;
        this.column = n3 - 1;
        if (this.buffer == null || n4 != this.buffer.length) {
            this.available = this.bufsize = n4;
            this.buffer = new char[n4];
            this.bufline = new int[n4];
            this.bufcolumn = new int[n4];
        }
        this.prevCharIsCR = false;
        this.prevCharIsLF = false;
        this.maxNextCharInd = 0;
        this.inBuf = 0;
        this.tokenBegin = 0;
        this.bufpos = -1;
    }

    public void ReInit(Reader reader, int n2, int n3) {
        this.ReInit(reader, n2, n3, 4096);
    }

    public void ReInit(Reader reader) {
        this.ReInit(reader, 1, 1, 4096);
    }

    public SimpleCharStream(InputStream inputStream, String string, int n2, int n3, int n4) throws UnsupportedEncodingException {
        this(string == null ? new InputStreamReader(inputStream) : new InputStreamReader(inputStream, string), n2, n3, n4);
    }

    public SimpleCharStream(InputStream inputStream, int n2, int n3, int n4) {
        this(new InputStreamReader(inputStream), n2, n3, n4);
    }

    public SimpleCharStream(InputStream inputStream, String string, int n2, int n3) throws UnsupportedEncodingException {
        this(inputStream, string, n2, n3, 4096);
    }

    public SimpleCharStream(InputStream inputStream, int n2, int n3) {
        this(inputStream, n2, n3, 4096);
    }

    public SimpleCharStream(InputStream inputStream, String string) throws UnsupportedEncodingException {
        this(inputStream, string, 1, 1, 4096);
    }

    public SimpleCharStream(InputStream inputStream) {
        this(inputStream, 1, 1, 4096);
    }

    public void ReInit(InputStream inputStream, String string, int n2, int n3, int n4) throws UnsupportedEncodingException {
        this.ReInit(string == null ? new InputStreamReader(inputStream) : new InputStreamReader(inputStream, string), n2, n3, n4);
    }

    public void ReInit(InputStream inputStream, int n2, int n3, int n4) {
        this.ReInit(new InputStreamReader(inputStream), n2, n3, n4);
    }

    public void ReInit(InputStream inputStream, String string) throws UnsupportedEncodingException {
        this.ReInit(inputStream, string, 1, 1, 4096);
    }

    public void ReInit(InputStream inputStream) {
        this.ReInit(inputStream, 1, 1, 4096);
    }

    public void ReInit(InputStream inputStream, String string, int n2, int n3) throws UnsupportedEncodingException {
        this.ReInit(inputStream, string, n2, n3, 4096);
    }

    public void ReInit(InputStream inputStream, int n2, int n3) {
        this.ReInit(inputStream, n2, n3, 4096);
    }

    public String GetImage() {
        if (this.bufpos >= this.tokenBegin) {
            return new String(this.buffer, this.tokenBegin, this.bufpos - this.tokenBegin + 1);
        }
        return String.valueOf(new String(this.buffer, this.tokenBegin, this.bufsize - this.tokenBegin)) + new String(this.buffer, 0, this.bufpos + 1);
    }

    public char[] GetSuffix(int n2) {
        char[] cArray = new char[n2];
        if (this.bufpos + 1 >= n2) {
            System.arraycopy(this.buffer, this.bufpos - n2 + 1, cArray, 0, n2);
        } else {
            System.arraycopy(this.buffer, this.bufsize - (n2 - this.bufpos - 1), cArray, 0, n2 - this.bufpos - 1);
            System.arraycopy(this.buffer, 0, cArray, n2 - this.bufpos - 1, this.bufpos + 1);
        }
        return cArray;
    }

    public void Done() {
        this.buffer = null;
        this.bufline = null;
        this.bufcolumn = null;
    }

    public void adjustBeginLineColumn(int n2, int n3) {
        int n4 = this.tokenBegin;
        int n5 = this.bufpos >= this.tokenBegin ? this.bufpos - this.tokenBegin + this.inBuf + 1 : this.bufsize - this.tokenBegin + this.bufpos + 1 + this.inBuf;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        while (n6 < n5 && this.bufline[n7 = n4 % this.bufsize] == this.bufline[n8 = ++n4 % this.bufsize]) {
            this.bufline[n7] = n2;
            n9 = n10 + this.bufcolumn[n8] - this.bufcolumn[n7];
            this.bufcolumn[n7] = n3 + n10;
            n10 = n9;
            ++n6;
        }
        if (n6 < n5) {
            this.bufline[n7] = n2++;
            this.bufcolumn[n7] = n3 + n10;
            while (n6++ < n5) {
                n7 = n4 % this.bufsize;
                this.bufline[n7] = this.bufline[n7] != this.bufline[++n4 % this.bufsize] ? n2++ : n2;
            }
        }
        this.line = this.bufline[n7];
        this.column = this.bufcolumn[n7];
    }
}

