/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.demeterf.examples;

import edu.neu.ccs.demeterf.ID;
import edu.neu.ccs.demeterf.TUCombiner;
import edu.neu.ccs.demeterf.Traversal;

public class TUTest {
    static void print(String string) {
        System.out.println(string);
    }

    public static void main(String[] stringArray) {
        Bin bin = new Bin(new Div(), new Bin(new Plus(), new Bin(new Plus(), new Bin(new Times(), new Num(9), new Num(6)), new Num(8)), new Bin(new Minus(), new Num(5), new Num(7))), new Num(4));
        TUTest.print("  Before: " + bin);
        TUTest.print("     Sum: " + TUCombiner.traverse(bin, new Add()));
        TUTest.print("    Mult: " + TUCombiner.traverse(bin, new Mult()));
        TUTest.print("   Count: " + TUCombiner.traverse(bin, new Count()));
    }

    static class Count
    extends TUCombiner<Integer> {
        Count() {
        }

        @Override
        public Integer fold(Integer n2, Integer n3) {
            return n2 + n3;
        }

        @Override
        public Integer combine() {
            return 0;
        }

        int combine(Num num) {
            return 1;
        }
    }

    static class Add
    extends Count {
        Add() {
        }

        @Override
        int combine(Num num) {
            return num.num;
        }
    }

    static class Mult
    extends Add {
        Mult() {
        }

        @Override
        public Integer fold(Integer n2, Integer n3) {
            return n2 * n3;
        }

        @Override
        public Integer combine() {
            return 1;
        }
    }

    static abstract class Exp {
        Exp() {
        }

        public String toString() {
            return (String)new Traversal(new ID(){

                String combine(Num num, int n2) {
                    return "" + n2;
                }

                String combine(Bin bin, String string, String string2, String string3) {
                    return "(" + string2 + " " + string + " " + string3 + ")";
                }

                String combine(Plus plus) {
                    return "+";
                }

                String combine(Minus minus) {
                    return "-";
                }

                String combine(Times times) {
                    return "*";
                }

                String combine(Div div) {
                    return "/";
                }
            }).traverse(this);
        }
    }

    static class Num
    extends Exp {
        int num;

        Num(int n2) {
            this.num = n2;
        }

        @Override
        public String toString() {
            return "" + this.num;
        }
    }

    static class Bin
    extends Exp {
        Op op;
        Exp left;
        Exp right;

        Bin(Op op, Exp exp, Exp exp2) {
            this.op = op;
            this.left = exp;
            this.right = exp2;
        }
    }

    static abstract class Op {
        Op() {
        }
    }

    static class Plus
    extends Op {
        Plus() {
        }
    }

    static class Minus
    extends Op {
        Minus() {
        }
    }

    static class Times
    extends Op {
        Times() {
        }
    }

    static class Div
    extends Op {
        Div() {
        }
    }
}

