/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.demeterf.examples;

import edu.neu.ccs.demeterf.ID;
import edu.neu.ccs.demeterf.Traversal;
import edu.neu.ccs.demeterf.demfgen.lib.RBColor;
import edu.neu.ccs.demeterf.demfgen.lib.RBLeaf;
import edu.neu.ccs.demeterf.demfgen.lib.RBNode;
import edu.neu.ccs.demeterf.demfgen.lib.RBTree;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JComponent;
import javax.swing.JFrame;

public class RBTest {
    public static void main(String[] stringArray) {
        new Frame();
    }

    static class Frame
    extends JFrame {
        Frame() {
            super("Tree Test: Hit some keys!!");
            this.setSize(400, 300);
            this.setLocation(50, 50);
            this.setDefaultCloseOperation(3);
            TC tC = new TC();
            this.getContentPane().add(tC);
            this.addKeyListener(tC);
            this.setVisible(true);
        }

        static class TC
        extends JComponent
        implements KeyListener {
            RBTree<Integer> tree = RBTree.create((Comparable[])new Integer[0]);

            TC() {
            }

            @Override
            public void paint(Graphics graphics) {
                new Traversal(new Painter(graphics)).traverse(this.tree, new Painter.Trip(30, 10, this.getWidth()));
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
            }

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                char c = keyEvent.getKeyChar();
                this.tree = !keyEvent.isAltDown() ? this.tree.insert(Integer.valueOf(c)) : this.tree.remove(Integer.valueOf(c));
                this.repaint();
            }
        }
    }

    static class Painter
    extends ID {
        Graphics g;

        Painter(Graphics graphics) {
            this.g = graphics;
        }

        Trip update(RBNode rBNode, RBNode.left left2, Trip trip) {
            return new Trip(trip.h + 60, trip.l, trip.mid());
        }

        Trip update(RBNode rBNode, RBNode.right right2, Trip trip) {
            return new Trip(trip.h + 60, trip.mid(), trip.r);
        }

        int combine(RBNode rBNode, Color color2, int n2, int n3, int n4, Trip trip) {
            this.g.setColor(color2);
            this.g.fillOval(trip.mid() - 15, trip.h, 30, 30);
            String string = "" + (char)n2;
            this.g.setColor(Color.white);
            this.g.drawChars(string.toCharArray(), 0, string.length(), trip.mid() - 4 * string.length(), trip.h + 20);
            return 0;
        }

        int combine(RBLeaf<Integer> rBLeaf, Trip trip) {
            this.g.setColor(Color.black);
            this.g.fillOval(trip.mid(), trip.h, 5, 5);
            return 0;
        }

        Color combine(RBColor rBColor) {
            return rBColor.isBlack() ? Color.black : Color.red;
        }

        public static class Trip {
            int h;
            int l;
            int r;

            Trip(int n2, int n3, int n4) {
                this.h = n2;
                this.l = n3;
                this.r = n4;
            }

            int mid() {
                return (this.l + this.r) / 2;
            }
        }
    }
}

