/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.demeterf.examples;

import edu.neu.ccs.demeterf.Bc;
import edu.neu.ccs.demeterf.ID;
import edu.neu.ccs.demeterf.Traversal;

public class FuncTest {
    public static void main(String[] stringArray) {
        List<Integer> list = List.from(new Integer[]{1, 5, 2, 6, 3, 4, 7});
        System.out.println(" String: " + list);
        System.out.println(" Length: " + new Traversal(new Length()).traverse(list));
        System.out.println("    Sum: " + new Traversal(new Sum()).traverse(list));
        System.out.println("   Add1: " + new Traversal(new Add1()).traverse(list));
        System.out.println("    I2S: " + new Traversal(new Int2Str()).traverse(list));
    }

    static abstract class List<T> {
        List() {
        }

        static <S> List<S> from(S[] SArray) {
            return List.from(SArray, 0);
        }

        static <S> List<S> from(S[] SArray, int n2) {
            if (n2 == SArray.length) {
                return new Empty();
            }
            return new Cons<S>(SArray[n2], List.from(SArray, n2 + 1));
        }

        public String toString() {
            return (String)new Traversal(new Fold<Object, String>(){

                @Override
                String combine(Empty<Object> empty) {
                    return "()";
                }

                @Override
                String combine(Cons<Object> cons, Object object, String string) {
                    return "(" + object + " " + string + ")";
                }
            }).traverse(this);
        }
    }

    static class Empty<T>
    extends List<T> {
        Empty() {
        }
    }

    static class Cons<T>
    extends List<T> {
        T first;
        List<T> rest;

        Cons(T t, List<T> list) {
            this.first = t;
            this.rest = list;
        }
    }

    static abstract class Fold<T, R>
    extends ID {
        Fold() {
        }

        abstract R combine(Empty<T> var1);

        abstract R combine(Cons<T> var1, T var2, R var3);
    }

    static class Length
    extends Fold<Integer, Integer> {
        Length() {
        }

        @Override
        Integer combine(Empty<Integer> empty) {
            return 0;
        }

        @Override
        Integer combine(Cons<Integer> cons, Integer n2, Integer n3) {
            return n3 + 1;
        }
    }

    static class Sum
    extends Length {
        Sum() {
        }

        @Override
        Integer combine(Cons<Integer> cons, Integer n2, Integer n3) {
            return n2 + n3;
        }
    }

    static class Add1
    extends Bc {
        Add1() {
        }

        int combine(int n2) {
            return n2 + 1;
        }
    }

    static class Int2Str
    extends Bc {
        Int2Str() {
        }

        String combine(int n2) {
            return "'" + n2 + "'";
        }
    }
}

