/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.demeterf.examples;

import edu.neu.ccs.demeterf.Bc;
import edu.neu.ccs.demeterf.ID;
import edu.neu.ccs.demeterf.Traversal;

public class EvalTest {
    public static void main(String[] stringArray) {
        Bin bin = new Bin(new Div(), new Bin(new Plus(), new Bin(new Plus(), new Bin(new Times(), new Num(9), new Num(6)), new Num(8)), new Bin(new Minus(), new Num(5), new Num(7))), new Num(4));
        System.out.println("  Before: " + bin);
        System.out.println("  AddOne: " + new Traversal(new AddOne()).traverse(bin));
        System.out.println("    Eval: " + new Traversal(new Eval()).traverse(bin));
        System.out.println(" Num2Str: " + new Traversal(new Num2Str()).traverse(bin));
        System.out.println("   Depth: " + new Traversal(new Depth()).traverse(bin));
    }

    static class AddOne
    extends Bc {
        AddOne() {
        }

        int combine(int n2) {
            return n2 + 1;
        }
    }

    static class Eval
    extends ID {
        Eval() {
        }

        int combine(Num num, int n2) {
            return n2;
        }

        Op combine(Op op) {
            return op;
        }

        int combine(Bin bin, Plus plus, int n2, int n3) {
            return n2 + n3;
        }

        int combine(Bin bin, Minus minus, int n2, int n3) {
            return n2 - n3;
        }

        int combine(Bin bin, Times times, int n2, int n3) {
            return n2 * n3;
        }

        int combine(Bin bin, Div div, int n2, int n3) {
            return n2 / n3;
        }
    }

    static class Depth
    extends ID {
        Depth() {
        }

        Op combine(Op op) {
            return op;
        }

        int combine(Exp exp, int n2) {
            return 0;
        }

        int combine(Exp exp, Op op, int n2, int n3) {
            return 1 + Math.max(n2, n3);
        }
    }

    static class Num2Str
    extends Bc {
        Num2Str() {
        }

        Str combine(Num num, int n2) {
            return new Str("" + num);
        }
    }

    static abstract class Exp {
        Exp() {
        }

        public String toString() {
            return (String)new Traversal(new ID(){

                String combine(Num num, int n2) {
                    return "" + n2;
                }

                String combine(Bin bin, String string, String string2, String string3) {
                    return "(" + string2 + " " + string + " " + string3 + ")";
                }

                String combine(Plus plus) {
                    return "+";
                }

                String combine(Minus minus) {
                    return "-";
                }

                String combine(Times times) {
                    return "*";
                }

                String combine(Div div) {
                    return "/";
                }

                String combine(Str str2, String string) {
                    return "\"" + string + "\"";
                }
            }).traverse(this);
        }
    }

    static class Num
    extends Exp {
        int num;

        Num(int n2) {
            this.num = n2;
        }

        @Override
        public String toString() {
            return "" + this.num;
        }
    }

    static class Str
    extends Exp {
        String str;

        Str(String string) {
            this.str = string;
        }
    }

    static class Bin
    extends Exp {
        Op op;
        Exp left;
        Exp right;

        Bin(Op op, Exp exp, Exp exp2) {
            this.op = op;
            this.left = exp;
            this.right = exp2;
        }
    }

    static abstract class Op {
        Op() {
        }
    }

    static class Plus
    extends Op {
        Plus() {
        }
    }

    static class Minus
    extends Op {
        Minus() {
        }
    }

    static class Times
    extends Op {
        Times() {
        }
    }

    static class Div
    extends Op {
        Div() {
        }
    }
}

