/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.demeterf.dispatch;

import edu.neu.ccs.demeterf.dispatch.ClassType;
import edu.neu.ccs.demeterf.dispatch.NamedStar;
import edu.neu.ccs.demeterf.dispatch.StarType;
import edu.neu.ccs.demeterf.dispatch.TypeSearchException;
import edu.neu.ccs.demeterf.util.Util;
import java.util.Stack;

public abstract class Type {
    static ClsP[] baseTypes = new ClsP[]{new ClsP("int", Integer.TYPE), new ClsP("long", Long.TYPE), new ClsP("float", Float.TYPE), new ClsP("double", Double.TYPE), new ClsP("char", Character.TYPE), new ClsP("byte", Byte.TYPE)};
    static Stack<String> searchPath = new Stack();

    static {
        Type.addPath("");
        Type.addPath("java.lang.");
    }

    public static Type forClass(Class<?> clazz) {
        return new ClassType(clazz);
    }

    public static Type star() {
        return new StarType();
    }

    public static Type star(String string) {
        return new NamedStar(string);
    }

    public static Type[] fromClassArray(Class<?>[] classArray, boolean bl) {
        Type[] typeArray = new Type[classArray.length];
        int n2 = 0;
        while (n2 < classArray.length) {
            Class<?> clazz = classArray[n2];
            if (clazz == null && Util.allowNull) {
                typeArray[n2] = Type.star();
            } else {
                if (bl) {
                    clazz = Util.box(clazz);
                }
                typeArray[n2] = Type.forClass(clazz);
            }
            ++n2;
        }
        return typeArray;
    }

    public static Class<?> classForName(String string) {
        return Type.searchForClass(string);
    }

    public static Type forName(String string) {
        return Type.forClass(Type.classForName(string));
    }

    public static Type forName(String string, boolean bl) {
        Class<?> clazz = Type.classForName(string);
        if (bl) {
            clazz = Util.box(clazz);
        }
        return Type.forClass(clazz);
    }

    public static void addPath(String string) {
        if (string.length() > 0 && string.charAt(string.length() - 1) != '.') {
            string = String.valueOf(string) + ".";
        }
        searchPath.insertElementAt(string, 0);
    }

    public static Class<?> searchForClass(String string) {
        if (Character.isLowerCase(string.charAt(0))) {
            int n2 = 0;
            while (n2 < baseTypes.length) {
                if (Type.baseTypes[n2].s.equals(string)) {
                    return Type.baseTypes[n2].c;
                }
                ++n2;
            }
        }
        for (String string2 : searchPath) {
            try {
                return Class.forName(String.valueOf(string2) + string);
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        String string3 = "";
        for (String string2 : searchPath) {
            if (string2.length() <= 0) continue;
            string3 = String.valueOf(string3) + "     " + string2 + "*\n";
        }
        throw new TypeSearchException(" ** Class Not Found: " + string + "\n  Search Paths:\n" + string3);
    }

    public abstract boolean isAssignableFrom(Type var1);

    public abstract boolean isAssignableFrom(Class<?> var1);

    public abstract Type getSuperClass();

    public abstract boolean equals(Object var1);

    public abstract String getSimpleName();

    public boolean isClass() {
        return false;
    }

    public boolean isStar() {
        return false;
    }

    public abstract Class<?> getType();

    public abstract Type boxedType();

    public abstract Type unboxedType();

    public String toString() {
        return this.getSimpleName();
    }

    static class ClsP {
        String s;
        Class<?> c;

        ClsP(String string, Class<?> clazz) {
            this.s = string;
            this.c = clazz;
        }
    }
}

