/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.demeterf.dispatch;

import edu.neu.ccs.demeterf.demfgen.lib.Empty;
import edu.neu.ccs.demeterf.demfgen.lib.List;
import edu.neu.ccs.demeterf.dispatch.ConstrEntry;
import edu.neu.ccs.demeterf.dispatch.DBEntry;
import edu.neu.ccs.demeterf.dispatch.LenPred;
import edu.neu.ccs.demeterf.dispatch.MethodEntry;
import edu.neu.ccs.demeterf.dispatch.Type;
import edu.neu.ccs.demeterf.dispatch.TypePred;
import edu.neu.ccs.demeterf.dispatch.TypeSort;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;

public class MethodDB<M> {
    static boolean debug = false;
    private List<DBEntry<M>> methods;

    public static List<DBEntry<Method>> getMethods(Class<?> clazz, String string) {
        List list = new Empty<DBEntry<Method>>();
        while (clazz != null && !clazz.equals(Object.class)) {
            Method[] methodArray = clazz.getDeclaredMethods();
            int n2 = 0;
            int n3 = methodArray.length;
            while (n2 < n3) {
                MethodEntry methodEntry;
                Method method = methodArray[n2];
                if (method.getName().equals(string) && list.index(methodEntry = new MethodEntry(method)) < 0) {
                    list = list.push(methodEntry);
                }
                ++n2;
            }
            clazz = clazz.getSuperclass();
        }
        return list;
    }

    public static MethodDB<Method> createMethodDB(Class<?> clazz, String string) {
        return new MethodDB<Method>(MethodDB.getMethods(clazz, string));
    }

    public static MethodDB<Constructor<?>> createConstrDB(Class<?> clazz) {
        List list = new Empty();
        Constructor<?>[] constructorArray = clazz.getDeclaredConstructors();
        int n2 = 0;
        int n3 = constructorArray.length;
        while (n2 < n3) {
            Constructor<?> constructor = constructorArray[n2];
            list = list.push(new ConstrEntry(constructor));
            ++n2;
        }
        return new MethodDB(list);
    }

    public static void setDebug(boolean bl) {
        debug = bl;
    }

    public static boolean isDebug() {
        return debug;
    }

    public MethodDB(List<DBEntry<M>> list) {
        this.methods = list;
    }

    public List<DBEntry<M>> reduce(Type[] typeArray) {
        int n2 = 0;
        List<DBEntry<M>> list = this.methods.filter(new LenPred(typeArray.length));
        List<DBEntry<M>> list2 = list;
        if (list2.isEmpty()) {
            return list2;
        }
        if (debug) {
            System.out.println(" Left: " + list2);
        }
        while (!list2.isEmpty() && n2 < typeArray.length) {
            list = list2;
            list2 = list2.filter(new TypePred(typeArray[n2], n2));
            if (debug) {
                System.out.println(" Left: " + list2);
            }
            if (list2.isEmpty()) continue;
            ++n2;
        }
        if (list2.isEmpty()) {
            list2 = list;
        }
        return list2.filter(new LenPred(n2));
    }

    public M match(Class<?>[] classArray) {
        return this.match(Type.fromClassArray(classArray, true));
    }

    public M match(Type[] typeArray) {
        DBEntry<M> dBEntry = this.matchEntry(typeArray);
        return dBEntry != null ? (M)dBEntry.getMethod() : null;
    }

    public List<DBEntry<M>> matchEntrys(Type[] typeArray) {
        List<DBEntry<M>> list = this.reduce(typeArray);
        return list.sort(new TypeSort());
    }

    public DBEntry<M> matchEntry(Type[] typeArray) {
        List<DBEntry<M>> list = this.matchEntrys(typeArray);
        return list.isEmpty() ? null : list.top();
    }

    public String toString() {
        return this.methods.toString();
    }

    public String toString(String string) {
        return this.methods.toString(string, "");
    }
}

