/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.demeterf.dispatch;

import edu.neu.ccs.demeterf.dispatch.Type;
import java.util.Arrays;

public class DBEntry<M> {
    private static Type object = Type.forClass(Object.class);
    private M method;
    private String name;
    private Type[] argTypes;
    private Type retType;

    public DBEntry(M m, String string, Class<?> clazz, Class<?>[] classArray) {
        this(m, string, Type.forClass(clazz), Type.fromClassArray(classArray, true));
    }

    public DBEntry(M m, String string, Type type2, Type[] typeArray) {
        this.method = m;
        this.name = string;
        this.retType = type2;
        this.argTypes = typeArray;
    }

    public M getMethod() {
        return this.method;
    }

    public int numArgs() {
        return this.argTypes.length;
    }

    public Type arg(int n2) {
        if (n2 < this.numArgs()) {
            return this.argTypes[n2];
        }
        return object;
    }

    public Type retType() {
        return this.retType;
    }

    public boolean equals(Object object) {
        return object instanceof DBEntry && Arrays.deepEquals(this.argTypes, ((DBEntry)object).argTypes) && this.retType.equals(((DBEntry)object).retType);
    }

    public int hashCode() {
        return Arrays.deepHashCode(this.argTypes) + this.retType.hashCode() * 17;
    }

    public String toString() {
        String string = String.valueOf(this.retType.getSimpleName()) + " " + this.name + "(";
        int n2 = 0;
        while (n2 < this.argTypes.length) {
            string = String.valueOf(string) + this.argTypes[n2].getSimpleName();
            if (n2 < this.argTypes.length - 1) {
                string = String.valueOf(string) + ", ";
            }
            ++n2;
        }
        return String.valueOf(string) + ")";
    }
}

