/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.demeterf.demfgen.lib;

import edu.neu.ccs.demeterf.demfgen.lib.List;
import edu.neu.ccs.demeterf.demfgen.lib.RBTree;
import java.util.Comparator;
import java.util.Iterator;

public class Set<X>
implements Iterable<X> {
    private RBTree<Wrap<X>> tree;
    private Comparator<X> comp;

    private Set() {
        this((Comparator<X>)new CComp(), RBTree.create((Comparable[])new Wrap[0]));
    }

    private Set(Comparator<X> comparator) {
        this(comparator, RBTree.create((Comparable[])new Wrap[0]));
    }

    private Set(List<X> list, final Comparator<X> comparator) {
        this(comparator, RBTree.create(list.map(new List.Map<X, Wrap<X>>(){

            @Override
            public Wrap<X> map(X x) {
                return new Wrap(x, comparator);
            }
        })));
    }

    public Set(List<X> list) {
        this(list, new CComp());
    }

    public Set(X ... XArray) {
        this(List.create(XArray), new CComp());
    }

    public Set(Comparator<X> comparator, X ... XArray) {
        this(List.create(XArray), comparator);
    }

    public static <X extends Comparable<X>> Set<X> create() {
        return new Set<X>();
    }

    public static <X> Set<X> create(Comparator<X> comparator) {
        return new Set<X>(comparator, RBTree.create((Comparable[])new Wrap[0]));
    }

    public static <X extends Comparable<X>> Set<X> create(List<X> list) {
        return new Set<X>(list);
    }

    public static <X> Set<X> create(List<X> list, Comparator<X> comparator) {
        return new Set<X>(list, comparator);
    }

    private Set(Comparator<X> comparator, List<Wrap<X>> list) {
        this(comparator, RBTree.create(list));
    }

    private Set(Comparator<X> comparator, RBTree<Wrap<X>> rBTree) {
        this.tree = rBTree;
        this.comp = comparator;
    }

    private Set<X> make(RBTree<Wrap<X>> rBTree) {
        return new Set<X>(this.comp, rBTree);
    }

    private Set<X> make(List<Wrap<X>> list) {
        return new Set<X>(this.comp, list);
    }

    private List<Wrap<X>> toWrapList() {
        return this.tree.toList();
    }

    public boolean contains(X x) {
        return this.tree.contains(new Wrap<X>(x, this.comp));
    }

    public boolean isEmpty() {
        return this.tree.isLeaf();
    }

    public Set<X> add(X x) {
        return this.make(this.tree.insert(new Wrap<X>(x, this.comp)));
    }

    public Set<X> remove(X x) {
        return this.make(this.tree.remove(new Wrap<X>(x, this.comp)));
    }

    public boolean subseteq(Set<X> set) {
        return set.tree.containsAll(this.tree);
    }

    public Set<X> union(Set<X> set) {
        return this.make(this.tree.insertAll(set.tree));
    }

    public Set<X> intersect(final Set<X> set) {
        return this.make(this.toWrapList().filter(new List.Pred<Wrap<X>>(){

            @Override
            public boolean huh(Wrap<X> wrap) {
                return set.tree.contains(wrap);
            }
        }));
    }

    public Set<X> difference(final Set<X> set) {
        return this.make(this.toWrapList().filter(new List.Pred<Wrap<X>>(){

            @Override
            public boolean huh(Wrap<X> wrap) {
                return !set.tree.contains(wrap);
            }
        }));
    }

    public List<X> toList() {
        return this.toWrapList().map(new List.Map<Wrap<X>, X>(){

            @Override
            public X map(Wrap<X> wrap) {
                return wrap.x;
            }
        });
    }

    @Override
    public Iterator<X> iterator() {
        return this.toList().iterator();
    }

    public boolean equals(Object object) {
        if (!(object instanceof Set)) {
            return false;
        }
        Set set = (Set)object;
        return set.tree.containsAll(this.tree) && this.tree.containsAll(set.tree);
    }

    public String toString() {
        return "{ " + this.toList().toString(" ", "") + " }";
    }

    private static class Wrap<X>
    implements Comparable<Wrap<X>> {
        X x;
        Comparator<X> comp;

        Wrap(X x, Comparator<X> comparator) {
            this.x = x;
            this.comp = comparator;
        }

        @Override
        public int compareTo(Wrap<X> wrap) {
            return this.comp.compare(this.x, wrap.x);
        }

        public boolean equals(Object object) {
            if (!(object instanceof Wrap)) {
                return false;
            }
            return this.x.equals(((Wrap)object).x);
        }

        public String toString() {
            return this.x.toString();
        }
    }

    private static class CComp<X>
    implements Comparator<X> {
        private CComp() {
        }

        @Override
        public int compare(X x, X x2) {
            return ((Comparable)x).compareTo(x2);
        }
    }
}

