/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.demeterf.demfgen.lib;

import edu.neu.ccs.demeterf.demfgen.lib.Entry;
import edu.neu.ccs.demeterf.demfgen.lib.List;
import edu.neu.ccs.demeterf.demfgen.lib.RBTree;
import java.util.Comparator;
import java.util.Iterator;

public class Map<Key, Val>
implements Iterable<Entry<Key, Val>> {
    private RBTree<Entry<Key, Val>> tree;
    private Comparator<Key> comp;

    private Map() {
        this(RBTree.create((Comparable[])new Entry[0]), new Entry.CComp());
    }

    private Map(Comparator<Key> comparator) {
        this(RBTree.create((Comparable[])new Entry[0]), comparator);
    }

    private Map(List<Entry<Key, Val>> list, Comparator<Key> comparator) {
        this(RBTree.create(list), comparator);
    }

    public Map(List<Entry<Key, Val>> list) {
        this(list, new Entry.CComp());
    }

    public static <Key extends Comparable<Key>, Val> Map<Key, Val> create() {
        return new Map<Key, Val>();
    }

    public static <Key, Val> Map<Key, Val> create(Comparator<Key> comparator) {
        return new Map<Key, Val>(comparator);
    }

    public static <Key, Val> Map<Key, Val> create(List<Entry<Key, Val>> list, Comparator<Key> comparator) {
        return new Map<Key, Val>(RBTree.create(list), comparator);
    }

    public static <Key extends Comparable<Key>, Val> Map<Key, Val> create(List<Entry<Key, Val>> list) {
        return new Map<Key, Val>(RBTree.create(list), new Entry.CComp());
    }

    private Map(RBTree<Entry<Key, Val>> rBTree, Comparator<Key> comparator) {
        this.tree = rBTree;
        this.comp = comparator;
    }

    private Map<Key, Val> make(RBTree<Entry<Key, Val>> rBTree) {
        return new Map<Key, Val>(rBTree, this.comp);
    }

    private Map<Key, Val> make(List<Entry<Key, Val>> list) {
        return new Map<Key, Val>(list, this.comp);
    }

    private boolean contains(Entry<Key, Val> entry) {
        return this.tree.contains(entry);
    }

    public boolean containsKey(Key Key) {
        return this.tree.contains(Entry.create(Key, null, this.comp));
    }

    public boolean isEmpty() {
        return this.tree.isLeaf();
    }

    public Map<Key, Val> put(Key Key, Val Val) {
        return this.make(this.tree.insert(Entry.create(Key, Val, this.comp)));
    }

    public Map<Key, Val> remap(Key Key, Val Val) {
        Entry<Key, Val> entry = Entry.create(Key, Val, this.comp);
        return this.make(!this.containsKey(Key) ? this.tree.insert(entry) : this.tree.replace(entry));
    }

    public Val get(Key Key) {
        return this.tree.find(Entry.create(Key, null, this.comp)).val;
    }

    public Map<Key, Val> remove(Key Key) {
        return this.make(this.tree.remove(Entry.create(Key, null, this.comp)));
    }

    public Map<Key, Val> merge(Map<Key, Val> map) {
        return this.make(this.tree.insertAll(map.tree));
    }

    public Map<Key, Val> merge(Map<Key, Val> map, final Merge<Val> merge) {
        return this.make(map.toList().fold(new List.Fold<Entry<Key, Val>, RBTree<Entry<Key, Val>>>(){

            @Override
            public RBTree<Entry<Key, Val>> fold(Entry<Key, Val> entry, RBTree<Entry<Key, Val>> rBTree) {
                if (!rBTree.contains(entry)) {
                    return rBTree.insert(entry);
                }
                return rBTree.replace(Entry.create(entry.key, merge.merge(entry.val, rBTree.find(entry).val), Map.this.comp));
            }
        }, this.tree));
    }

    public List<Key> keys() {
        return this.toList().map(new List.Map<Entry<Key, Val>, Key>(){

            @Override
            public Key map(Entry<Key, Val> entry) {
                return entry.key;
            }
        });
    }

    public List<Val> values() {
        return this.toList().map(new List.Map<Entry<Key, Val>, Val>(){

            @Override
            public Val map(Entry<Key, Val> entry) {
                return entry.val;
            }
        });
    }

    public List<Entry<Key, Val>> toList() {
        return this.tree.toList();
    }

    @Override
    public Iterator<Entry<Key, Val>> iterator() {
        return this.toList().iterator();
    }

    public String toString() {
        return "[ " + this.toList().toString(" ", "") + " ]";
    }

    public static abstract class Merge<Val> {
        public abstract Val merge(Val var1, Val var2);
    }
}

