/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.demeterf.demfgen.lib;

import edu.neu.ccs.demeterf.demfgen.lib.Cons;
import edu.neu.ccs.demeterf.demfgen.lib.Empty;
import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class List<X>
implements Iterable<X> {
    public static <X> List<X> create(X ... XArray) {
        return List.create(XArray, 0);
    }

    public static <X> List<X> create(X[] XArray, int n2) {
        return n2 == XArray.length ? new Empty() : List.create(XArray, n2 + 1).push(XArray[n2]);
    }

    public List<X> push(X x) {
        return new Cons<X>(x, this);
    }

    public List<X> push(List<X> list) {
        return list.append(this);
    }

    public List<X> reverse() {
        return this.reverse(new Empty());
    }

    public List<X> reverse(int n2) {
        return this.reverse(new Empty(), n2);
    }

    public String toString() {
        return this.toString(" ", "");
    }

    public int index(X x) {
        return this.index(x, 0);
    }

    public int index(Pred<X> pred) {
        return this.index(pred, 0);
    }

    public boolean same(List<X> list) {
        return this.containsAll(list) && list.containsAll(this);
    }

    public boolean same(List<X> list, Comp<X> comp) {
        return this.containsAll(list, comp) && list.containsAll(this, comp);
    }

    public List<X> pop(int n2) {
        return n2 == 0 ? this : this.pop().pop(n2 - 1);
    }

    public abstract List<X> append(List<X> var1);

    public abstract List<X> append(X var1);

    public abstract X top();

    public abstract List<X> pop();

    public abstract boolean isEmpty();

    public abstract boolean contains(X var1);

    public abstract boolean contains(Pred<X> var1);

    public abstract boolean containsAny(List<X> var1);

    public abstract boolean containsAll(List<X> var1);

    public abstract boolean containsAll(List<X> var1, Comp<X> var2);

    protected abstract int index(X var1, int var2);

    protected abstract int index(Pred<X> var1, int var2);

    public abstract X find(X var1);

    public abstract X find(Pred<X> var1);

    public abstract List<X> remove(X var1);

    public abstract List<X> remove(Pred<X> var1);

    public abstract int length();

    public abstract X lookup(int var1);

    public abstract String toString(String var1, String var2);

    public abstract String toString(Stringer<X> var1);

    public List<X> filterout(final Pred<X> pred) {
        return this.filter(new Pred<X>(){

            @Override
            public boolean huh(X x) {
                return !pred.huh(x);
            }
        });
    }

    public abstract List<X> filter(Pred<X> var1);

    public abstract <Y> Y fold(Fold<X, Y> var1, Y var2);

    public abstract <Y> List<Y> map(Map<X, Y> var1);

    public abstract List<X> add(X var1, int var2);

    public abstract List<X> remove(int var1);

    public abstract List<X> insert(X var1, Comp<X> var2);

    public abstract List<X> sort(Comp<X> var1);

    public abstract List<X> reverse(List<X> var1);

    public abstract List<X> reverse(List<X> var1, int var2);

    public X[] toArray(X[] XArray) {
        return this.toArray(XArray, 0);
    }

    protected abstract X[] toArray(X[] var1, int var2);

    @Override
    public Iterator<X> iterator() {
        return new ListIterator(this);
    }

    public abstract <Y, Z> List<Z> zip(Zip<X, Y, Z> var1, List<Y> var2);

    public static <X> List<X> buildlist(Build<X> build, int n2) {
        return List.buildlist(build, 0, n2);
    }

    private static <X> List<X> buildlist(Build<X> build, int n2, int n3) {
        return n2 >= n3 ? List.create(new Object[0]) : List.buildlist(build, n2 + 1, n3).push(build.build(n2));
    }

    public abstract List<X> replace(X var1, X var2);

    public abstract List<X> replace(Pred<X> var1, X var2);

    public abstract List<X> replaceAll(X var1, X var2);

    public abstract List<X> replaceAll(Pred<X> var1, X var2);

    public static abstract class Stringer<X> {
        public abstract String toString(X var1, List<X> var2);
    }

    public static abstract class Pred<X> {
        public abstract boolean huh(X var1);
    }

    public static abstract class Comp<X> {
        public abstract boolean comp(X var1, X var2);

        public Pred<X> curry(X x) {
            return new Curry<X>(this, x);
        }

        private static class Curry<X>
        extends Pred<X> {
            X x;
            Comp<X> c;

            Curry(Comp<X> comp, X x) {
                this.c = comp;
                this.x = x;
            }

            @Override
            public boolean huh(X x) {
                return this.c.comp(this.x, x);
            }
        }
    }

    public static abstract class Map<X, Y> {
        public abstract Y map(X var1);
    }

    public static abstract class Fold<X, Y> {
        public abstract Y fold(X var1, Y var2);
    }

    public static abstract class Zip<X, Y, Z> {
        public abstract Z zip(X var1, Y var2);
    }

    public static abstract class Build<X> {
        public abstract X build(int var1);
    }

    static class ListIterator<X>
    implements Iterator<X> {
        List<X> inner;

        ListIterator(List<X> list) {
            this.inner = list;
        }

        @Override
        public boolean hasNext() {
            return !this.inner.isEmpty();
        }

        @Override
        public X next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("next()");
            }
            X x = this.inner.top();
            this.inner = this.inner.pop();
            return x;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove()");
        }
    }
}

