/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.demeterf.demfgen.lib;

import java.util.Comparator;

public class Entry<Key, Val>
implements Comparable<Entry<Key, Val>> {
    public Key key;
    public Val val;
    private Comparator<Key> comp;

    public Entry(Key Key, Val Val) {
        this.key = Key;
        this.val = Val;
        this.comp = new CComp();
    }

    private Entry(Key Key, Val Val, Comparator<Key> comparator) {
        this.key = Key;
        this.val = Val;
        this.comp = comparator;
    }

    @Override
    public int compareTo(Entry<Key, Val> entry) {
        return this.comp.compare(this.key, entry.key);
    }

    public boolean equals(Object object) {
        if (!(object instanceof Entry)) {
            return false;
        }
        return this.key.equals(((Entry)object).key);
    }

    public String toString() {
        return "(" + this.key + " -> " + this.val + ")";
    }

    public static <Key extends Comparable<Key>, Val> Entry<Key, Val> create(Key Key, Val Val) {
        return new Entry<Key, Val>(Key, Val, new CComp());
    }

    public static <Key, Val> Entry<Key, Val> create(Key Key, Val Val, Comparator<Key> comparator) {
        return new Entry<Key, Val>(Key, Val, comparator);
    }

    static class CComp<Key>
    implements Comparator<Key> {
        CComp() {
        }

        @Override
        public int compare(Key Key, Key Key2) {
            return ((Comparable)Key).compareTo(Key2);
        }
    }
}

