/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.demeterf.demfgen.classes;

import edu.neu.ccs.demeterf.TUCombiner;
import edu.neu.ccs.demeterf.Traversal;
import edu.neu.ccs.demeterf.control.Fields;
import edu.neu.ccs.demeterf.demfgen.ClassGen;
import edu.neu.ccs.demeterf.demfgen.Diff;
import edu.neu.ccs.demeterf.demfgen.GraphGen;
import edu.neu.ccs.demeterf.demfgen.IncludeGen;
import edu.neu.ccs.demeterf.demfgen.Make;
import edu.neu.ccs.demeterf.demfgen.ParseGen;
import edu.neu.ccs.demeterf.demfgen.classes.BehDef;
import edu.neu.ccs.demeterf.demfgen.classes.BehFile;
import edu.neu.ccs.demeterf.demfgen.classes.DoGen;
import edu.neu.ccs.demeterf.demfgen.classes.ImportList;
import edu.neu.ccs.demeterf.demfgen.classes.IncludeList;
import edu.neu.ccs.demeterf.demfgen.classes.LookDef;
import edu.neu.ccs.demeterf.demfgen.classes.PackageDef;
import edu.neu.ccs.demeterf.demfgen.classes.ParseException;
import edu.neu.ccs.demeterf.demfgen.classes.Print;
import edu.neu.ccs.demeterf.demfgen.classes.RE;
import edu.neu.ccs.demeterf.demfgen.classes.RTFileNotFound;
import edu.neu.ccs.demeterf.demfgen.classes.RTParseException;
import edu.neu.ccs.demeterf.demfgen.classes.TE;
import edu.neu.ccs.demeterf.demfgen.classes.TheParser;
import edu.neu.ccs.demeterf.demfgen.classes.TokenMgrError;
import edu.neu.ccs.demeterf.demfgen.classes.TypeDef;
import edu.neu.ccs.demeterf.demfgen.classes.TypeDefList;
import edu.neu.ccs.demeterf.demfgen.dgp.DGPFunc;
import edu.neu.ccs.demeterf.demfgen.lib.List;
import edu.neu.ccs.demeterf.demfgen.lib.Option;
import edu.neu.ccs.demeterf.dispatch.Type;
import edu.neu.ccs.demeterf.dispatch.TypeSearchException;
import edu.neu.ccs.demeterf.util.Util;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringBufferInputStream;

public class DemFGenMain {
    public IncludeList incl;
    public PackageDef pkg;
    public LookDef look;
    public ImportList imports;
    public TypeDefList types;

    public DemFGenMain(IncludeList includeList, PackageDef packageDef, LookDef lookDef, ImportList importList, TypeDefList typeDefList) {
        this.incl = includeList;
        this.pkg = packageDef;
        this.look = lookDef;
        this.imports = importList;
        this.types = typeDefList;
    }

    public boolean equals(Object object) {
        if (!(object instanceof DemFGenMain)) {
            return false;
        }
        DemFGenMain demFGenMain = (DemFGenMain)object;
        return this.incl.equals(demFGenMain.incl) && this.pkg.equals(demFGenMain.pkg) && this.look.equals(demFGenMain.look) && this.imports.equals(demFGenMain.imports) && this.types.equals(demFGenMain.types);
    }

    public static DemFGenMain parse(String string) throws ParseException {
        return new TheParser(new StringBufferInputStream(string)).parse_DemFGenMain();
    }

    public static DemFGenMain parse(InputStream inputStream) throws ParseException {
        return new TheParser(inputStream).parse_DemFGenMain();
    }

    public static DemFGenMain parse(Reader reader) throws ParseException {
        return new TheParser(reader).parse_DemFGenMain();
    }

    static void p(String string) {
        System.err.print(string);
    }

    static String gap(int n2) {
        if (n2 <= 0) {
            return "";
        }
        return " " + DemFGenMain.gap(n2 - 1);
    }

    public static void abort() {
        System.exit(1);
    }

    public static void header(String string) {
        DemFGenMain.p("\n                 \u25e4------------------------------\u25e5\n                 |          DemFGen " + string + DemFGenMain.gap(12 - string.length()) + "|" + "\n                 |          " + Diff.buildDate + "          |" + "\n                 \u25e3------------------------------\u25e2\n");
    }

    public static void main(String[] stringArray) throws Exception {
        List<String>[] listArray = Util.splitArgs(stringArray);
        List<String> list = listArray[Util.OPTS];
        String[] stringArray2 = listArray[Util.ARGS].toArray((String[])new String[listArray[Util.ARGS].length()]);
        if (list.contains("--help")) {
            DemFGenMain.usage(true);
        }
        if (stringArray2.length != 3) {
            DemFGenMain.usage(false);
        }
        String string = stringArray2[0];
        String string2 = stringArray2[1];
        String string3 = stringArray2[2];
        try {
            List<DemFGenMain> list2 = DemFGenMain.resolveCDFile(string);
            List<BehDef> list3 = DemFGenMain.resolveBEHFile(string2);
            Util.addBuiltIns(DoGen.class);
            if (list.contains("--graph")) {
                DemFGenMain.p("\n ** Generating DOT Graph...\n");
                GraphGen.genGraph(list2, string3);
                System.exit(0);
            } else {
                boolean bl = !list.contains("--noparse");
                String string4 = "";
                int n2 = list.index(new List.Pred<String>(){

                    @Override
                    public boolean huh(String string) {
                        return string.startsWith("--dgp:");
                    }
                });
                if (n2 >= 0) {
                    DemFGenMain.p("\n ** Generating DGP Functions...\n     [");
                    Type.addPath("edu.neu.ccs.demeterf.demfgen.dgp.");
                    List<DGPFunc> list4 = DemFGenMain.doDGP(Util.separateOption("dgp", list), list2, string3);
                    string4 = list4.fold(new List.Fold<DGPFunc, String>(){

                        @Override
                        public String fold(DGPFunc dGPFunc, String string) {
                            return "    public " + (dGPFunc.override() ? String.valueOf(Diff.d.override) + " " : "") + dGPFunc.methodReturn() + " " + dGPFunc.methodName() + "(){\n" + dGPFunc.methodBody() + "\n    }\n" + string;
                        }
                    }, "");
                    DemFGenMain.doDGPGen(list4, list2, string3);
                    DemFGenMain.p("]\n");
                }
                DemFGenMain.p("\n ** Generating Classes...\n");
                ClassGen.genClasses(list2, list3, string3, bl, string4);
                if (bl) {
                    DemFGenMain.p(" ** Generating Parser...\n");
                    ParseGen.genParser(list2, string3);
                }
                if (list.contains("--build")) {
                    Make.make(string3, !list.contains("--noparse"));
                }
                DemFGenMain.p(" ** Finished\n");
                System.exit(0);
            }
        }
        catch (RE rE) {
            DemFGenMain.error(rE, "Runtime");
        }
        catch (RTParseException rTParseException) {
            DemFGenMain.error(rTParseException, "Parse");
        }
        catch (FileNotFoundException fileNotFoundException) {
            DemFGenMain.error(fileNotFoundException, "File");
        }
        catch (RTFileNotFound rTFileNotFound) {
            DemFGenMain.error(rTFileNotFound, "File");
        }
        catch (TE tE) {
            DemFGenMain.error(tE, "Type");
        }
        System.exit(1);
    }

    static void error(Throwable throwable, String string) {
        DemFGenMain.p("\n\n !! " + string + " Error:\n" + throwable.getMessage() + "\n\n");
    }

    public static List<DemFGenMain> resolveCDFile(String string) throws FileNotFoundException {
        try {
            return DemFGenMain.resolveCDFile(new FileInputStream(string), string);
        }
        catch (ParseException parseException) {
            throw new RTParseException(" ** CD File: \"" + string + "\"\n" + parseException.getMessage());
        }
        catch (TokenMgrError tokenMgrError) {
            throw new RTParseException(" ** CD File: \"" + string + "\"\n" + tokenMgrError.getMessage());
        }
    }

    public static List<DemFGenMain> resolveCDFile(InputStream inputStream, String string) throws ParseException {
        DemFGenMain demFGenMain = DemFGenMain.parse(inputStream);
        List<DemFGenMain> list = IncludeGen.resolveCDs(demFGenMain.incl, string).push(demFGenMain);
        demFGenMain.imports = IncludeGen.allImports(list);
        return list;
    }

    public static List<BehDef> resolveBEHFile(String string) throws FileNotFoundException {
        try {
            return DemFGenMain.resolveBEHFile(new FileInputStream(string), string);
        }
        catch (ParseException parseException) {
            throw new RTParseException(" ** BEH File: \"" + string + "\"\n" + parseException.getMessage());
        }
        catch (TokenMgrError tokenMgrError) {
            throw new RTParseException(" ** BEH File: \"" + string + "\"\n" + tokenMgrError.getMessage());
        }
    }

    public static List<BehDef> resolveBEHFile(InputStream inputStream, String string) throws ParseException {
        BehFile behFile = BehFile.parse(inputStream);
        return behFile.behs.toList().append((BehDef)((Object)IncludeGen.resolveBEHs(behFile.incl, string)));
    }

    static void usage(boolean bl) {
        DemFGenMain.p("\n" + (bl ? "" : " !! Incorrect arguments\n !!") + " Usage: DemFGen [Options] <CD-File> <BEH-File> <Output-Dir>\n\n" + "    The order/placement of options doesn't matter, but the relative\n" + "       order of the manditory ones must be as shown.\n\n" + "    CD-File contains the CD to be generated,\n" + "    BEH-File contains the behavior to be used with classes,\n" + "    Output-Dir is the directory to place generated files\n" + "    Options can be: \n" + "      --help           : Print this usage information.\n" + "      --build          : " + Diff.d.makeInfo + "\n" + "      --noparse        : Don't generate the parser files or methods\n" + "      --graph          : Just print a Dot file to StdOut\n" + "      --dgp:C1:...:Cn  : A Colon seperated List of Data-generic function\n" + "                           classes to be run/generated. Each class must be a\n" + "                           subclass of edu.neu.ccs.demeterf.demfgen.dgp.DGPFunc\n" + "                           and accessible in the current classpath.\n" + "                       * Predefined classes are Print, Display, and ToStr,\n" + "                           which generate " + (Diff.d.isJava() ? "print(), display(), and toStr()" : "Print(), Display(), and ToStr()") + "\n" + "                           methods respectively. Any/all may be used together.\n" + "                       * Each one includes a separate Class that generates the\n" + "                           same functionality in a " + (Diff.d.isJava() ? "t" : "T") + "oString method. Those\n" + "                           classes are named PrintToString, DisplayToString,\n" + "                           and ToString.  Obviously, only one may be used.\n" + "                       * See the demfgen.dgp package source for more details.\n\n");
        System.exit(1);
    }

    static List<DGPFunc> doDGP(String[] stringArray, List<DemFGenMain> list, String string) {
        List<DGPFunc> list2 = List.create(new DGPFunc[0]);
        String[] stringArray2 = stringArray;
        int n2 = 0;
        int n3 = stringArray2.length;
        while (n2 < n3) {
            String string2 = stringArray2[n2];
            try {
                Class<?> clazz = Type.classForName(string2);
                if (DGPFunc.class.isAssignableFrom(clazz)) {
                    list2 = list2.push((DGPFunc)clazz.getConstructor(new Class[0]).newInstance(new Object[0]));
                } else {
                    DemFGenMain.p("\n !! DGP Error: Class '" + string2 + "' isn't a subclass of DGPFunc\n\n");
                    DemFGenMain.abort();
                }
            }
            catch (TypeSearchException typeSearchException) {
                DemFGenMain.p("\n !! DGP Error: Couldn't Find function class: '" + string2 + "'\n\n");
                DemFGenMain.abort();
            }
            catch (Exception exception) {
                DemFGenMain.p("\n !! DGP Error: Couldn't create function: '" + string2 + "'\n\n");
                DemFGenMain.abort();
            }
            ++n2;
        }
        return list2;
    }

    public static List<TypeDef> justTypes(List<DemFGenMain> list) {
        List<TypeDef> list2 = TUCombiner.traverse(list, new JustTypes());
        return list2;
    }

    static void doDGPGen(List<DGPFunc> list, List<DemFGenMain> list2, String string) {
        List<TypeDef> list3 = DemFGenMain.justTypes(list2);
        String string2 = "" + IncludeGen.allImports(list2);
        String string3 = list2.top().pkg.toString();
        String string4 = list2.top().pkg.hasPkg() ? Diff.d.classEnd : "";
        for (DGPFunc dGPFunc : list) {
            Traversal traversal = new Traversal(dGPFunc.functionObj(), dGPFunc.control());
            String string5 = (String)traversal.traverse(Option.some(list3));
            ClassGen.writeFile(dGPFunc.fileName(), "." + Diff.d.fileSuffix, String.valueOf(string5) + string4 + "\n", string, String.valueOf(string3) + Diff.d.parserImport + string2);
            DemFGenMain.p(dGPFunc.fileName() + ", ");
        }
    }

    public String print() {
        return ((Print._LT)new Traversal(new Print()).traverse(this)).toString();
    }

    public static class incl
    extends Fields.any {
    }

    public static class pkg
    extends Fields.any {
    }

    public static class look
    extends Fields.any {
    }

    public static class imports
    extends Fields.any {
    }

    public static class types
    extends Fields.any {
    }

    static class JustTypes
    extends TUCombiner<List<TypeDef>> {
        JustTypes() {
        }

        @Override
        public List<TypeDef> combine() {
            return List.create(new TypeDef[0]);
        }

        @Override
        public List<TypeDef> fold(List<TypeDef> list, List<TypeDef> list2) {
            return list.append((TypeDef)((Object)list2));
        }

        List<TypeDef> combine(TypeDef typeDef) {
            return ((List)this.combine()).push(typeDef);
        }
    }
}

