
package player.rawmaterialsolver;

import edu.neu.ccs.satsolver.InputUpdateI;
import edu.neu.ccs.satsolver.PairI;
import edu.neu.ccs.satsolver.PolynomialI;
import gen.RelationNr;
import gen.Weight;

import java.util.Set;

/**
 * An instance of {@link InputUpdateI} used in {@link RawMaterialSolverState}
 * when a variable is set.
 */
public class InputUpdate implements InputUpdateI {
  
  private final PolynomialI before;
  private final PairSetBuilder addedBuilder;
  private final PairSetBuilder subtractedBuilder;
  
  public InputUpdate(double totalWeight, PolynomialI before) {
    this.before = before;
    addedBuilder = new PairSetBuilder(totalWeight);
    subtractedBuilder = new PairSetBuilder(totalWeight);
  }
  
  /**
   * Should be called every time the set variable causes a relation to be
   * reduces
   * 
   * @param p The relation number before being reduced
   * @param u The relation number after being reduced
   * @param w The weight of the constraint
   */
  public void reduceConstraint(RelationNr p, RelationNr u, Weight w) {
    subtractedBuilder.add(p, w);
    addedBuilder.add(u, w);
  }
  
  public Set<PairI> getAddedPairs() {
    return addedBuilder.buildSet();
  }

  public PolynomialI getPolynomialBefore() {
    return before;
  }

  public Set<PairI> getSubtractedPairs() {
    return subtractedBuilder.buildSet();
  }
}