package neg;

import java.util.*;
import org.aspectj.lang.reflect.*;

/**
 * Counts the methods executed in Computation and
 * prints all the results at the end of the program.
 */
public aspect MethodCounts {

  pointcut callTargets(double d): 
    call(* neg.Computation.*(double)) && args(d);
    
  final static Map signatures2counts = new HashMap();
    
  before(double d): 
    if(AspectConfig.METHOD_COUNTS) 
    && callTargets(d) {
    MethodSignature sig = (MethodSignature)thisJoinPoint.getSignature();
    String sigString = String.valueOf(sig);
    Number n = (Number)
      signatures2counts.get(sigString);
    if (n == null) n = new Integer(0);
    n = new Integer(n.intValue() + 1);
    signatures2counts.put(sigString, n);
  }
  
  pointcut results(): 
    execution(void *.main(String[]));
  
  after(): if(AspectConfig.METHOD_COUNTS) && results() {
    System.out.println("\n\n");
    System.out.println("Method                            Count");
    System.out.println("=======================================");
    for (Iterator it = signatures2counts.entrySet().iterator(); it.hasNext();) {
      Map.Entry entry = (Map.Entry)it.next();
      Object sig = entry.getKey();
      Object cnt = entry.getValue();
      System.out.println(sig + " \t " + cnt);
    }
  }
}
