package neg;

import org.aspectj.lang.reflect.*;

/**
 * This guy throws an error if we pass a negative value
 * to a method in Computation.
 */
public aspect EnsurePositive {
  
  pointcut callTargets(double d): 
    call(* neg.Computation.*(double)) && args(d);
    
  before(double d): 
    if (AspectConfig.ENSURE_POSITIVE) 
    && callTargets(d) {
    if (d < 0) {
      Object caller = thisJoinPoint.getThis();
      Object callee = thisJoinPoint.getTarget();
      MethodSignature sig = 
        (MethodSignature)thisJoinPoint.getSignature();
      SourceLocation loc = 
        thisJoinPoint.getSourceLocation();
      String msg = 
        "\n   " + caller + " tried passing " +
        "\n   " + callee + " (" + sig + ") a negative value: " + d +
        "\n   at location: " + loc;
      throw new RuntimeException(msg);
    }
  }
}
