/**
 * Code by Daniel Rinehart <danielr@neophi.com>
 * Created for CSG260 Fall 2006 with Karl Lieberherr
 */
package edu.neu.ccs.satsolver.util;

import junit.framework.TestCase;

public class PolynomialTest extends TestCase {
	public void testMultiply() {
		Polynomial result = new Polynomial(1, -2, 1, 0).multiply(2);
		assertEquals(2.0, result.getCoefficient(3), Polynomial.DELTA);
		assertEquals(-4.0, result.getCoefficient(2), Polynomial.DELTA);
		assertEquals(2.0, result.getCoefficient(1), Polynomial.DELTA);
		assertEquals(0.0, result.getCoefficient(0), Polynomial.DELTA);
	}

	public void testAdd() {
		Polynomial result = new Polynomial(1, -2, 1, 0).add(new Polynomial(0, 1, -2, 1));
		assertEquals(1.0, result.getCoefficient(3), Polynomial.DELTA);
		assertEquals(-1.0, result.getCoefficient(2), Polynomial.DELTA);
		assertEquals(-1.0, result.getCoefficient(1), Polynomial.DELTA);
		assertEquals(1.0, result.getCoefficient(0), Polynomial.DELTA);
	}

	public void testDifferentiate() {
		Polynomial result = new Polynomial(-1, 3, -3, 1).differentiate();
		assertEquals(0.0, result.getCoefficient(3), Polynomial.DELTA);
		assertEquals(-3.0, result.getCoefficient(2), Polynomial.DELTA);
		assertEquals(6.0, result.getCoefficient(1), Polynomial.DELTA);
		assertEquals(-3.0, result.getCoefficient(0), Polynomial.DELTA);
		result = result.differentiate();
		assertEquals(0.0, result.getCoefficient(3), Polynomial.DELTA);
		assertEquals(0.0, result.getCoefficient(2), Polynomial.DELTA);
		assertEquals(-6.0, result.getCoefficient(1), Polynomial.DELTA);
		assertEquals(6.0, result.getCoefficient(0), Polynomial.DELTA);
	}

	public void testGetCoefficients() {
		Polynomial polynomial = new Polynomial(0, -1, 1, 0);
		assertEquals(0.0, polynomial.getCoefficient(3), Polynomial.DELTA);
		assertEquals(-1.0, polynomial.getCoefficient(2), Polynomial.DELTA);
		assertEquals(1.0, polynomial.getCoefficient(1), Polynomial.DELTA);
		assertEquals(0.0, polynomial.getCoefficient(0), Polynomial.DELTA);
	}

	public void testSolve0() {
		try {
			new Polynomial(0, 0, 0, 1).solve0();
			fail("No Error");
		} catch (UnsupportedOperationException exception) {

		}
		Polynomial polynomial = new Polynomial(0, 0, 1, 0);
		double results[] = polynomial.solve0();
		assertEquals(1, results.length);
		assertEquals(0.0, results[0], Polynomial.DELTA);

		polynomial = new Polynomial(0, 0, -2, 2);
		results = polynomial.solve0();
		assertEquals(1, results.length, Polynomial.DELTA);
		assertEquals(1.0, results[0], Polynomial.DELTA);

		polynomial = new Polynomial(0, -3, 6, -3);
		results = polynomial.solve0();
		assertEquals(2, results.length);
		assertEquals(1.0, results[0], Polynomial.DELTA);
		assertEquals(1.0, results[1], Polynomial.DELTA);

		polynomial = new Polynomial(0, 3, -4, 1);
		results = polynomial.solve0();
		assertEquals(2, results.length);
		assertEquals(1.0, results[0], Polynomial.DELTA);
		assertEquals(1.0 / 3.0, results[1], Polynomial.DELTA);

		polynomial = new Polynomial(0, 2, 1, 2);
		results = polynomial.solve0();
		assertEquals(0, results.length);

		try {
			new Polynomial(1, 1, 1, 1).solve0();
			fail("No Error");
		} catch (UnsupportedOperationException exception) {

		}
	}

	public void testEval() {
		Polynomial polynomial = new Polynomial(0, 0, 0, 1);
		assertEquals(1.0, polynomial.eval(0), Polynomial.DELTA);
		assertEquals(1.0, polynomial.eval(1), Polynomial.DELTA);

		polynomial = new Polynomial(0, 0, 2, 1);
		assertEquals(1.0, polynomial.eval(0), Polynomial.DELTA);
		assertEquals(3.0, polynomial.eval(1), Polynomial.DELTA);
		assertEquals(7.0, polynomial.eval(3), Polynomial.DELTA);
		assertEquals(-3.0, polynomial.eval(-2), Polynomial.DELTA);

		polynomial = new Polynomial(0, -3, 2, 1);
		assertEquals(1.0, polynomial.eval(0), Polynomial.DELTA);
		assertEquals(0.0, polynomial.eval(1), Polynomial.DELTA);
		assertEquals(-20.0, polynomial.eval(3), Polynomial.DELTA);
		assertEquals(-15.0, polynomial.eval(-2), Polynomial.DELTA);

		polynomial = new Polynomial(1, -3, 2, 1);
		assertEquals(1.0, polynomial.eval(0), Polynomial.DELTA);
		assertEquals(1.0, polynomial.eval(1), Polynomial.DELTA);
		assertEquals(7.0, polynomial.eval(3), Polynomial.DELTA);
		assertEquals(-23.0, polynomial.eval(-2), Polynomial.DELTA);
	}

	public void testMax0To1() {
		Polynomial polynomial = new Polynomial(1, -3, 3, 0);
		double result = polynomial.maxX0To1();
		assertEquals(1.0, result, Polynomial.DELTA);

		polynomial = new Polynomial(0, -1, 1, 0);
		result = polynomial.maxX0To1();
		assertEquals(0.5, result, Polynomial.DELTA);

		polynomial = new Polynomial(0, 1, -2, 1);
		result = polynomial.maxX0To1();
		assertEquals(0.0, result, Polynomial.DELTA);

		polynomial = new Polynomial(1, 0, 0, 0);
		result = polynomial.maxX0To1();
		assertEquals(1.0, result, Polynomial.DELTA);

		polynomial = new Polynomial(-1, 0, 0, 0);
		result = polynomial.maxX0To1();
		assertEquals(0.0, result, Polynomial.DELTA);

		polynomial = new Polynomial(1, -2, 1, 0);
		result = polynomial.maxX0To1();
		assertEquals(1.0 / 3.0, result, Polynomial.DELTA);

		polynomial = new Polynomial(1.0 / 3.0, 0, 2, 0);
		result = polynomial.maxX0To1();
		assertEquals(1.0, result, Polynomial.DELTA);
	}

	public void testToString() {
		assertEquals("x^3-3.0x^2+3.0x", new Polynomial(1, -3, 3, 0).toString());
		assertEquals("-x^3-3.0x^2+3.0x", new Polynomial(-1, -3, 3, 0).toString());
		assertEquals("x^3-x^2+x+1.0", new Polynomial(1, -1, 1, 1).toString());
		assertEquals("-x^3+x^2-x-1.0", new Polynomial(-1, 1, -1, -1).toString());
	}
}
