/**
 * Code by Daniel Rinehart <danielr@neophi.com>
 * Created for CSG260 Fall 2006 with Karl Lieberherr
 */
package edu.neu.ccs.satsolver.util;

import edu.neu.ccs.satsolver.OutputI;
import edu.neu.ccs.satsolver.PolynomialI;

/**
 * Output holds the maximum bias and polynomial that were generated as a call to
 * SATSolverUtil.
 */
public class Output implements OutputI {

	private Polynomial polynomial;

	private double bias;

	/**
	 * Create a new output object which wraps the polynomial.
	 * 
	 * @param polynomial
	 *            Polynomial
	 */
	public Output(Polynomial polynomial) {
		this.polynomial = polynomial;
		this.bias = polynomial.maxX0To1();
	}

	/**
	 * @see edu.neu.ccs.satsolver.OutputI#getMaxBias()
	 */
	public double getMaxBias() {
		return bias;
	}

	/**
	 * @see edu.neu.ccs.satsolver.OutputI#getPolynomial()
	 */
	public PolynomialI getPolynomial() {
		return polynomial;
	}

	/**
	 * @see java.lang.Object#toString()
	 */
	public String toString() {
		return "MaxBias: " + bias + "\n" + "Polynomial: " + polynomial.toString();
	}
}
