package edu.neu.ccs.satsolver;

/**
 * The PolynomialI interface manages a polynomial.
 * <p>
 * Example: 4.3x^2 is a polynomial where 4.3 is the coefficient constant and the
 * degree is 2.
 */
public interface PolynomialI {
    /**
     * Return the coefficient constant used in the polynomial for the degree
     * specified.
     * <p>
     * The valid request values are 0 <= degree <= 3.
     * 
     * @param degree
     *            Coefficient constant degree to return
     * @return Coefficient constant
     */
    public double getCoefficient(int degree);
}
