/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.satsolver;

import edu.neu.ccs.satsolver.InputInitialI;
import edu.neu.ccs.satsolver.InputUpdateI;
import edu.neu.ccs.satsolver.OutputI;
import edu.neu.ccs.satsolver.PairI;
import edu.neu.ccs.satsolver.PolynomialI;
import edu.neu.ccs.satsolver.util.AppSAT;
import edu.neu.ccs.satsolver.util.Output;
import edu.neu.ccs.satsolver.util.Polynomial;
import java.util.Iterator;

public class SATSolverUtil {
    private SATSolverUtil() {
    }

    public static OutputI calculateBias(InputInitialI inputInitialI) {
        PolynomialSum polynomialSum = SATSolverUtil.createPolynomialSum(inputInitialI.getPairs().iterator());
        if (!Polynomial.equal(1.0, polynomialSum.sum)) {
            throw new IllegalArgumentException("InputInitial's pair fractions do not add to 1.0 +/-" + Polynomial.DELTA + ". Got: " + polynomialSum.sum);
        }
        return new Output(polynomialSum.polynomial);
    }

    public static OutputI updateBias(InputUpdateI inputUpdateI) {
        Polynomial polynomial = SATSolverUtil.createInitialPolynomial(inputUpdateI);
        PolynomialSum polynomialSum = SATSolverUtil.createPolynomialSum(inputUpdateI.getAddedPairs().iterator());
        PolynomialSum polynomialSum2 = SATSolverUtil.createPolynomialSum(inputUpdateI.getSubtractedPairs().iterator());
        if (!Polynomial.equal(polynomialSum.sum, polynomialSum2.sum)) {
            throw new IllegalArgumentException("InputUpdate's added and subtracted pair fractions do not add to the same value +/-" + Polynomial.DELTA + ". Got: " + polynomialSum.sum + " and " + polynomialSum2.sum);
        }
        return new Output(polynomial.add(polynomialSum.polynomial).subtract(polynomialSum2.polynomial));
    }

    private static Polynomial createInitialPolynomial(InputUpdateI inputUpdateI) {
        if (inputUpdateI.getPolynomialBefore() instanceof Polynomial) {
            return (Polynomial)inputUpdateI.getPolynomialBefore();
        }
        PolynomialI polynomialI = inputUpdateI.getPolynomialBefore();
        return new Polynomial(polynomialI.getCoefficient(3), polynomialI.getCoefficient(2), polynomialI.getCoefficient(1), polynomialI.getCoefficient(0));
    }

    private static PolynomialSum createPolynomialSum(Iterator iterator) {
        Polynomial polynomial = null;
        double d = 0.0;
        while (iterator.hasNext()) {
            PairI pairI = (PairI)iterator.next();
            SATSolverUtil.verifyPair(pairI);
            Polynomial polynomial2 = AppSAT.appSAT(pairI.getRelationNumber()).multiply(pairI.getFraction());
            d += pairI.getFraction();
            if (polynomial == null) {
                polynomial = polynomial2;
                continue;
            }
            polynomial = polynomial.add(polynomial2);
        }
        return new PolynomialSum(polynomial, d);
    }

    private static void verifyPair(PairI pairI) {
        if (pairI.getRelationNumber() < 0 || pairI.getRelationNumber() > 255) {
            throw new IllegalArgumentException("Pair's relation number must be between 0 and 255 inclusive. Got: " + pairI.getRelationNumber());
        }
        if (pairI.getFraction() < 0.0 || pairI.getFraction() > 1.0) {
            throw new IllegalArgumentException("Pair's fraction must be between 0.0 and 1.0 inclusive. Got: " + pairI.getFraction());
        }
    }

    private static class PolynomialSum {
        public Polynomial polynomial;
        public double sum;

        public PolynomialSum(Polynomial polynomial, double d) {
            this.polynomial = polynomial;
            this.sum = d;
        }
    }
}

