package csu670.editors.scanners.rules;

import org.eclipse.jface.text.rules.WordRule;

import csu670.editors.Config;


/**
 * A IRule that will detect tokens.  Tokens are keywords that 
 * are not restricted to alpha numeric characters only.
 * 
 * @author Pok
 */
public class TokenRule extends WordRule {
	
	/**
	 * Create a rule that will detect the given tokens.
	 * @param tokens a list of tokens to detect.
	 */
	public TokenRule(String[] tokens) {
		super(new TokenDetector(tokens));
		for (int i=0; i<tokens.length; i++) {
			addWord(tokens[i], Config.TOKEN_ITOKEN);
		}
	}
	
}