package csu670.editors.scanners.rules;

import java.util.HashSet;

import org.eclipse.jface.text.rules.IWordDetector;


/**
 * Implements the IWordDetector to detect special tokens.  
 * Special tokens can be any characters, and is not 
 * restricted to alpha numeric characters.  
 * 
 * @author Pok
 * @see TokenRule
 */
public class TokenDetector implements IWordDetector {
	
	/** Character object sets **/
	private HashSet wordStart, wordPart;
	
	/**
	 * Default constructor.  Builds a set of all starting word 
	 * characters and word part characters to minimize searching.
	 */
	public TokenDetector(String[] tokens) {
		wordStart = new HashSet();
		wordPart = new HashSet();
		
		fillWordStart(tokens);
		fillWordPart(tokens);
	}

	
	/**
	 * Fill the wordStart set.
	 */
	private void fillWordStart(String[] strings) {
		for (int i=0; i<strings.length; i++) {
			String str = strings[i];
			if (str != null && str.length() > 0) {
				char c = str.charAt(0);
				//System.out.println("wordStart +=  " +c);
				wordStart.add(new Character(c));
			}
		}
	}
	
	/**
	 * Fill the wordPart set.
	 */
	private void fillWordPart(String[] strings) {
		for (int i=0; i<strings.length; i++) {
			String str = strings[i];
			if (str != null && str.length() > 0) {
				for (int j=1; j<str.length(); j++) {
					char c = str.charAt(j);
					//System.out.println("wordPart +=  " +c);
					wordPart.add(new Character(c));
				}
			}
		}
	}
	
	/**
	 * Implements super method to detect tokens
	 */
	public boolean isWordStart(char c) {
		return wordStart.contains(new Character(c));
	}

	/**
	 * Implements super method to detect tokens.
	 */
	public boolean isWordPart(char c) {
		return wordPart.contains(new Character(c));
	}
	
	
	
	
	
}