package csu670.editors.scanners.rules;

import org.eclipse.jface.text.rules.IWordDetector;


/**
 * Implements the IWordDetector to detect keywords.  
 * Keyword detector will only detect keywords that 
 * consist of only alpha numeric characters, so 
 * the keyword cannot be something like "_foo".
 * 
 * @author Pok
 * @see KeywordRule
 */
public class KeywordDetector implements IWordDetector {
	

	/**
	 * Default constructor.  
	 */
	public KeywordDetector() {
	}

	
	
	/**
	 * Implements super method to detect given word.  
	 * A character is a word start it is either a letter 
	 * or digit character.
	 */
	public boolean isWordStart(char c) {
		return Character.isLetterOrDigit(c);
	}

	/**
	 * Implements super method to detect given word.
	 * A character is a word part it is either a letter 
	 * or digit character.
	 */
	public boolean isWordPart(char c) {
		return Character.isLetterOrDigit(c);
	}
	
	
	
	
	
}