package csu670.editors.scanners;

import org.eclipse.jface.text.rules.*;


/**
 * Scanner that will partition the document.  The document will be 
 * partition into 2 different parts, the class dictionary partition 
 * and the traversal declaration partition.  Each partition will have 
 * its own Damager and Repairer object working on it.
 * 
 * @author Pok
 */
public class XAspectPartitionScanner extends RuleBasedPartitionScanner {
	
	
	/** Indicates the class dictionary partition of the document */
	public final static String XASPECT_CD = "__xaspect_cd";
	
	/** Indicates the traversal strategy partition of the document */
	public final static String XASPECT_TRAVERSAL = "__xaspect_traversal";
	



	/**
	 * Default constructor.
	 */
	public XAspectPartitionScanner() {
		IToken cdToken = new Token(XASPECT_CD);
		IToken traversalToken = new Token(XASPECT_TRAVERSAL);
		
		// List the rules
		IPredicateRule[] rules = new IPredicateRule[2];
		
		// Everything between the double curly braces are the class dictionary
		rules[0] = new MultiLineRule("{{", "}}", cdToken);
		
		// Everything between the single curly braces are the traversal strategies
		rules[1] = new MultiLineRule("{", "}", traversalToken);

		// Set the rules
		setPredicateRules(rules);
	}
}



