package csu670.editors.scanners;
import csu670.editors.*;
import csu670.editors.scanners.rules.KeywordRule;
import csu670.editors.scanners.rules.TokenRule;

import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.WhitespaceRule;


/**
 * Rule base scanner to highlight syntax.  This scanner is 
 * design to work on the traversal declaration partition 
 * of the document.  
 * 
 * @author Pok
 * @see csu670.editors.scanners.XAspectPartitionScanner
 */
public class TraversalScanner extends RuleBasedScanner {

	/**
	 * Keywords that will be highlighted.
	 */
	public static final String[] keywords = new String[] {
		"union", "except", "intersect", "declare", "XPath", 
		"strategy", "from", "to", "bypassing", "via", "context",
		"node"
	};
	
	/**
	 * Tokens that will be highlighted.
	 */
	public static final String[] tokens = new String[] {
		"->", "/", ":", ";", "|", "/+/",
		"(", ")", 
		"{", "}", 
	};
	
	/**
	 * Default constructor, will set up rules automaticly.
	 */
	public TraversalScanner() {
		IRule[] rules = new IRule[3];
		rules[0] = new KeywordRule(keywords);
		rules[1] = new TokenRule(tokens);
		rules[2] = new TokenRule(new String[] {"\""});
		setRules(rules);
	}
	
	
	
}
