package csu670.editors;


import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;

import csu670.editors.scanners.ClassDictionaryScanner;
import csu670.editors.scanners.TraversalScanner;
import csu670.editors.scanners.XAspectPartitionScanner;
import csu670.editors.scanners.XAspectScanner;



/**
 * The configuration for the text editor.
 * @author Pok
 *
 */
public class XAspectConfiguration extends SourceViewerConfiguration {


	/**
	 * Default Constructor.
	 */
	public XAspectConfiguration() {
		super();
	}
	
	
	/**
	 * Override the default reconciler with our custom one.
	 */
	public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
		PresentationReconciler reconciler = new PresentationReconciler();
		
		// Let the ClassDictionaryScanner work on the cd partition.
		DefaultDamagerRepairer dr1 = new DefaultDamagerRepairer(new ClassDictionaryScanner());
		reconciler.setDamager(dr1, XAspectPartitionScanner.XASPECT_CD);
		reconciler.setRepairer(dr1, XAspectPartitionScanner.XASPECT_CD);
		
		// Let the TraversalScanner work on the traversal partition.
		DefaultDamagerRepairer dr2 = new DefaultDamagerRepairer(new TraversalScanner());
		reconciler.setDamager(dr2, XAspectPartitionScanner.XASPECT_TRAVERSAL);
		reconciler.setRepairer(dr2, XAspectPartitionScanner.XASPECT_TRAVERSAL);
		
		// Rest of the document, let the default scanner work
		DefaultDamagerRepairer dr3 = new DefaultDamagerRepairer(new XAspectScanner());
		reconciler.setDamager(dr3, IDocument.DEFAULT_CONTENT_TYPE);
		reconciler.setRepairer(dr3, IDocument.DEFAULT_CONTENT_TYPE);
		
		
		
		return reconciler;
	}
	

	
	
}