package xAspectsEditor.editors;

import org.eclipse.jface.text.rules.*;

public class IxAspWordDetector implements IWordDetector{
	public static boolean isDash = false;
	public static boolean isUnary = false;
	public static boolean isArrow = false;
	public static boolean isSlash = false;
	public static boolean isSlashPlus = false;
	public static boolean isSlashPlusSlash = false;

	public boolean isWordStart(char c){
		resetStatics();
		if(Character.isLetterOrDigit(c)){
			return true;
		}
		if(c == '-'){
			isDash = true;
			return true;
		}
		else if(c == '/'){
			isSlash = true;
			return true;
		}
		else if(c == '|'){
			isUnary = true;
			return true;
		}
		return false;
	}
	public boolean isWordPart(char c) {
		if(isUnary || isArrow || isSlashPlusSlash){return false;}
		else if(isDash){
			isDash = false;
			if(c == '>'){
				isArrow = true;
				return true;
			}
		}
		else if(isSlash){
			isSlash = false;
			if(c == '+'){
				isSlashPlus = true;
				return true;
			}
		}
		else if(isSlashPlus){
			isSlashPlus = false;
			if(c == '/'){
				isSlashPlusSlash = true;
				return true;
			}
		}
		else if(Character.isLetterOrDigit(c)){
			return true;
		}
		return false;
	}
	public void resetStatics(){
		isDash = false;
		isUnary = false;
		isArrow = false;
		isSlash = false;
		isSlashPlus = false;
		isSlashPlusSlash = false;
	}
}

class IxAspSpecialDetector implements IWordDetector{
	public boolean isWordStart(char c){
		if(c == '>' || c == '<' || c == '=' || 
		   c == ':' || c == '(' || c == ')' || 
		   c == '.' || c == ';' || c == ','||
		   c == '{' || c == '}' || c == '"'){
			return true;
		}
		return false;
	}
	public boolean isWordPart(char c) {
		if(c == '>' || c == '<' || c == '=' || 
		   c == ':' || c == '(' || c == ')' || 
		   c == '.' || c == ';' || c == ',' ||
		   c == '{' || c == '}' || c == '"'){
			return true;
		}
		return false;
	}
}
