package MyEditor.editors;

import java.util.*;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.WordRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
						
						
public class MyRuleScanner extends RuleBasedScanner implements myTokenList{
	
	//Create new red color for highlighting
	private static Color Red_COLOR = new Color(Display.getCurrent(), new RGB(190, 0, 0));

	public MyRuleScanner() {
		
		//Create new token that has the color red
		IToken RedToken = new Token(new TextAttribute(Red_COLOR));
		
		//Declare an Array List to hold the rules
		List rules = new ArrayList();
		
		//Create an instance of WordRule for Words and Punctuation that need to be highlighted
		WordRule WordRules = new WordRule(new MyWordDetector(), Token.UNDEFINED);
		WordRule PunctuationRules = new WordRule(new MyPunctuationDetector(), Token.UNDEFINED);
		
		//Loop through the array HighlightWord and add these tokens to WordRules that will take the Red Token
		for(int i = 0; i<HighlightWord.length; i++){
			WordRules.addWord(HighlightWord[i],RedToken);
		}
		
		//Loop through the array HighlightPunc and add these tokens to PunctuationRules that will take the Red Token
		for(int i = 0; i<HighlightPunc.length; i++){
			PunctuationRules.addWord(HighlightPunc[i],RedToken);
		}
		
		//Add WordRules and PunctuationRules to our ArrayList rules
		rules.add(WordRules);
		rules.add(PunctuationRules);
		
		//Convert the ArrayList rules into an array of IRule
		IRule[] myRule2 = new IRule[rules.size()];
		rules.toArray(myRule2);
		
		//Tells the scanner the array of rules that it should follow
		setRules(myRule2);
		
	}
}
