/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.demeter.common.tg;

import edu.neu.ccs.demeter.common.tg.ClassGraph;
import edu.neu.ccs.demeter.common.tg.EdgePartsVisitor;
import edu.neu.ccs.demeter.common.tg.Mark;
import edu.neu.ccs.demeter.common.tg.UniversalVisitor;
import edu.neu.ccs.demeter.common.tg.Vertex;
import edu.neu.ccs.demeter.common.tg.__V_Vertex_markReachableBackward;
import edu.neu.ccs.demeter.common.tg.__V_Vertex_markReachableForward;
import java.util.BitSet;

public abstract class Edge {
    protected Vertex source;
    protected Vertex dest;
    protected Mark mark;

    public Vertex get_source() {
        return this.source;
    }

    public void set_source(Vertex new_source) {
        this.source = new_source;
    }

    public Vertex get_dest() {
        return this.dest;
    }

    public void set_dest(Vertex new_dest) {
        this.dest = new_dest;
    }

    public Mark get_mark() {
        return this.mark;
    }

    public void set_mark(Mark new_mark) {
        this.mark = new_mark;
    }

    public Edge(Vertex source, Vertex dest, Mark mark) {
        this.set_source(source);
        this.set_dest(dest);
        this.set_mark(mark);
    }

    public Edge() {
        this.mark = new Mark();
    }

    BitSet get_mask() {
        BitSet ret;
        Mark mark = this.get_mark();
        if (mark.get_both() != null) {
            return mark.get_both();
        }
        if (Mark.all_forw) {
            if (Mark.all_back) {
                ret = new BitSet();
                ret.set(0);
            } else {
                ret = mark.get_back();
            }
        } else if (Mark.all_back) {
            ret = mark.get_forw();
        } else {
            ret = (BitSet)mark.get_forw().clone();
            ret.and(mark.get_back());
        }
        mark.set_both(ret);
        return ret;
    }

    boolean get_forw(int i) {
        if (Mark.all_forw) {
            return true;
        }
        return this.mark.get_forw(i);
    }

    boolean get_back(int i) {
        if (Mark.all_back) {
            return true;
        }
        return this.mark.get_back(i);
    }

    void set_forw(int i) {
        this.mark.set_forw(i);
        ClassGraph.curForwTG.add(this);
        if (this.get_back(i)) {
            ClassGraph.curTG.add(this);
        }
    }

    void set_back(int i) {
        this.mark.set_back(i);
        if (this.get_forw(i)) {
            ClassGraph.curTG.add(this);
        }
    }

    String maskCode(String indent, String oldsetname, String newsetname) {
        String code = "";
        BitSet mask = this.get_mask();
        int i = 0;
        while (i < mask.size()) {
            if (mask.get(i)) {
                code = code + indent + newsetname + ".set(" + i + ");\n";
            }
            ++i;
        }
        code = code + indent + newsetname + ".and(" + oldsetname + ");\n";
        return code;
    }

    void universal_trv0_bef(UniversalVisitor _v_) {
        _v_.before(this);
    }

    void universal_trv0_aft(UniversalVisitor _v_) {
        _v_.after(this);
    }

    void universal_trv0(UniversalVisitor _v_) {
        _v_.before_source(this, this.source);
        this.source.universal_trv0(_v_);
        _v_.after_source(this, this.source);
        _v_.before_dest(this, this.dest);
        this.dest.universal_trv0(_v_);
        _v_.after_dest(this, this.dest);
        _v_.before_mark(this, this.mark);
        this.mark.universal_trv0(_v_);
        _v_.after_mark(this, this.mark);
    }

    void toAll_ClassGraph_trv_bef(UniversalVisitor __v0) {
        __v0.before(this);
    }

    void toAll_ClassGraph_trv_aft(UniversalVisitor __v0) {
        __v0.after(this);
    }

    void toAll_ClassGraph_trv(UniversalVisitor __v0) {
        __v0.before_mark(this, this.mark);
        this.mark.toAll_ClassGraph_trv(__v0);
        __v0.after_mark(this, this.mark);
    }

    void __trav_markReachableForward_Vertex_trv_bef(__V_Vertex_markReachableForward __v0) {
    }

    void __trav_markReachableForward_Vertex_trv_aft(__V_Vertex_markReachableForward __v0) {
    }

    void __trav_markReachableForward_Vertex_trv(__V_Vertex_markReachableForward __v0) {
        this.dest.__trav_markReachableForward_Vertex_trv(__v0);
    }

    void __trav_markReachableBackward_Vertex_trv_bef(__V_Vertex_markReachableBackward __v0) {
    }

    void __trav_markReachableBackward_Vertex_trv_aft(__V_Vertex_markReachableBackward __v0) {
    }

    void __trav_markReachableBackward_Vertex_trv(__V_Vertex_markReachableBackward __v0) {
        this.source.__trav_markReachableBackward_Vertex_trv(__v0);
    }

    public void toAll(EdgePartsVisitor __v0) {
        this.toAll_Edge_trv(__v0);
    }

    void toAll_Edge_trv_bef(EdgePartsVisitor __v0) {
        __v0.before(this);
    }

    void toAll_Edge_trv_aft(EdgePartsVisitor __v0) {
        __v0.after(this);
    }

    void toAll_Edge_trv(EdgePartsVisitor __v0) {
        __v0.before_source(this, this.source);
        this.source.toAll_Edge_trv(__v0);
        __v0.after_source(this, this.source);
        __v0.before_dest(this, this.dest);
        this.dest.toAll_Edge_trv(__v0);
        __v0.after_dest(this, this.dest);
    }
}

