import edu.neu.ccs.demeter.dj.*;
import java.util.*;

class Main {
  public static void main(String[] args) {
    ClassGraph cg = new ClassGraph(true,false); // constructed by reflection
    System.out.println("Class graph");
    System.out.println(cg);
    System.out.println("End of Class graph");
    A a = new A (
	   new B(
	    new D(
	     new E(
	      new F(7)
	     ),
	     new X( new F(9))
	    )
	   ), new C());

    Strategy sg = new Strategy("from A through X to F");
    Traversal tg1 = new Traversal(sg, cg);
    tg1.traverse(a, new MyVisitor());

    String whereToGo = "from A to F";
    Traversal tg = new Traversal(whereToGo ,cg);
    System.out.println(whereToGo);
    List result1 = a.gather(tg);
    System.out.println("List size = " + result1.size());

    whereToGo = "from A through X to F";
    tg = new Traversal(whereToGo ,cg);
    System.out.println(whereToGo);
    result1 = a.gather(tg);
    System.out.println("List size = " + result1.size());

    whereToGo = "{A -> X X ->F}";
    // same as whereToGo = "from A through X to F" except
    // that X is also a target;
    // The following strategy correctly specifies source and target
    //    whereToGo = "{source:A -> X X ->target:F}";
    tg = new Traversal(whereToGo ,cg);
    System.out.println(whereToGo);
    result1 = a.gather(tg);
    System.out.println("List size = " + result1.size());

    whereToGo = "{A ->F bypassing {X}}";
    tg = new Traversal(whereToGo ,cg);
    System.out.println(whereToGo);
    result1 = a.gather(tg);
    System.out.println("List size = " + result1.size());

  }
}