/**
 * This class provides some of the guidlines for keyword location by the 
 * XRuleScanner.
 * 
 * @author JSeifried
 * @version 0.1.0
 * @see XRuleScanner
 */
package jseifried.xaspecteditor.highlight;

import org.eclipse.jface.text.rules.IWordDetector;

public class XWordDetector implements IWordDetector, IXAspectKeys {

 public boolean isWordStart(char c) {	
  if (!Character.isLetter(c) & c != '_') return false;
  return true;
 }
  
 public boolean isWordPart(char c) {
  if (Character.isLetter(c) || Character.isDigit(c) 
    || c == '.' || c == '_' || c == '-') {
   return true;
  }
  return false;
 }	
}
