/**
 * Processes text in an XEditor accoring to its reconciler and the set of 
 * "X" rules defined.
 * 
 * @author JSeifried
 * @version 0.1.0
 * @see WordBeginRule
 * @see XPunctuationRule
 * @see XWordRule
 */
package jseifried.xaspecteditor.highlight;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.EndOfLineRule;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.MultiLineRule;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class XRuleScanner extends RuleBasedScanner implements IXAspectKeys{

 /** Highlight attributes for comments (green). */
 private static Color COMMENT_COLOR = new Color(
   Display.getCurrent(), new RGB(64, 160, 128));

 /** Highlight attributes for keywords (navy). */
 private static Color X_COLOR = new Color(
   Display.getCurrent(), new RGB(0, 0, 200));

/**
 * Process text accoring to defined "X" rules.
 */
 public XRuleScanner() {
  IToken commentToken = new Token(new TextAttribute(COMMENT_COLOR));
  IToken xToken = new Token(new TextAttribute(X_COLOR));
  List rules= new ArrayList();
  rules.add(new EndOfLineRule("//", commentToken));
  rules.add(new MultiLineRule("/*", "*/" , commentToken));
  XWordRule wordRule= new XWordRule();
  XPunctuationRule punctRule = new XPunctuationRule();
  
  //Highlight all Class Dictionary keywords
  for (int i= 0; i < cdwords.length; i++) 
   wordRule.addWord(cdwords[i], xToken);

  // Highlight all Strategy keywords
  for (int i= 0; i < swords.length; i++) 
   wordRule.addWord(swords[i], xToken);

  // Highlight all Node Set keywords
  for (int i= 0; i < nswords.length; i++) 
   wordRule.addWord(nswords[i], xToken);

  // Highlight all keyword punctuation
  for (int i= 0; i < punctuation.length; i++) 
   punctRule.addWord(punctuation[i], xToken);	

  rules.add(wordRule);
  rules.add(punctRule);
  IRule[] result= new IRule[rules.size()];
  rules.toArray(result);
  setRules(result);
 }
}


