package jseifried.xaspecteditor.dj;
import java.util.Vector;

import edu.neu.ccs.demeter.Ident;
import edu.neu.ccs.demeter.Text;
import edu.neu.ccs.demeter.aplib.cd.ClassGraph;
class PrintVisitor extends UniversalVisitor {
  protected int indent;
  public int get_indent() { return indent; }
  public void set_indent(int new_indent) { indent = new_indent; }
  protected boolean needSpace;
  public boolean get_needSpace() { return needSpace; }
  public void set_needSpace(boolean new_needSpace) { needSpace = new_needSpace; }
  public PrintVisitor() { super(); }
  public PrintVisitor(int indent, boolean needSpace) {
    super();
    set_indent(indent);
    set_needSpace(needSpace);
  }

    protected java.io.PrintWriter out = new java.io.PrintWriter(System.out, true);
    java.io.PrintWriter get_out()             { return out; }
    void set_out(java.io.PrintWriter new_out) { out = new_out; }
    PrintVisitor(java.io.PrintWriter out)     { set_out(out); }
    PrintVisitor(java.io.PrintStream out)
      { set_out(new java.io.PrintWriter(out, true)); }
  
  public void finish() { out.flush(); }
  protected void space() {
    if (needSpace) out.print(" ");
    needSpace = false;
  }
  public void before_classdictionaryname(ClassDictionaryL source, ClassDictionaryName dest) {
    space();
    out.print("aspect");
    needSpace = true;
    out.print("(");
    needSpace = false;
    space();
    out.print("ClassDictionary");
    needSpace = true;
    out.print(")");
    needSpace = false;
  }
  public void before_traversalname(SelectorL source, TraversalName dest) {
    space();
    out.print("aspect");
    needSpace = true;
    out.print("(");
    needSpace = false;
    space();
    out.print("Traversal");
    needSpace = true;
    out.print(")");
    needSpace = false;
  }
  public void before_strategydef_list(SelectorL source, StrategyDef_List dest) {
    out.print("{");
    needSpace = false;
  }
  public void before_selectorname(SelectorL source, SelectorName dest) {
    space();
    out.print("declare");
    needSpace = true;
    space();
    out.print("chosen");
    needSpace = true;
    space();
    out.print("selector:");
    needSpace = false;
  }
  public void after_selectorname(SelectorL source, SelectorName dest) {
    out.print(";");
    needSpace = false;
  }
  public void before_classdictionaryname(SelectorL source, ClassDictionaryName dest) {
    space();
    out.print("declare");
    needSpace = true;
    space();
    out.print("chosen");
    needSpace = true;
    space();
    out.print("class");
    needSpace = true;
    space();
    out.print("dictionary:");
    needSpace = false;
  }
  public void after_classdictionaryname(SelectorL source, ClassDictionaryName dest) {
    out.print(";");
    needSpace = false;
  }
  public void after(SelectorL host) {
    out.print("}");
    needSpace = false;
  }
  public void before_strategyname(StrategyDef source, StrategyName dest) {
    space();
    out.print("declare");
    needSpace = true;
    space();
    out.print("strategy");
    needSpace = true;
    out.print(":");
    needSpace = false;
  }
  public void before_strategyexpr(StrategyDef source, StrategyExpr dest) {
    out.print(":");
    needSpace = false;
  }
  public void before_nodesubsetname(NodeSubsetDef source, NodeSubsetName dest) {
    space();
    out.print("declare");
    needSpace = true;
    space();
    out.print("node");
    needSpace = true;
    space();
    out.print("set");
    needSpace = true;
    out.print(":");
    needSpace = false;
  }
  public void before_nodesubsetexpression(NodeSubsetDef source, NodeSubsetExpression dest) {
    out.print(":");
    needSpace = false;
  }
  public void after_nodesubsetexpression(NodeSubsetDef source, NodeSubsetExpression dest) {
    out.print(";");
    needSpace = false;
  }
  public void before_strategyname(GraphNodes source, StrategyName dest) {
    space();
    out.print("nodes");
    needSpace = true;
  }
  public void before_classname(GraphNodeRegExp source, ClassName dest) {
    space();
    out.print("regexp");
    needSpace = true;
  }
  public void before(WildCard host) {
    out.print("*");
    needSpace = false;
  }
  public void before(Union host) {
    space();
    out.print("or");
    needSpace = true;
  }
  public void before(Intersection host) {
    space();
    out.print("and");
    needSpace = true;
  }
  public void before(Complement host) {
    out.print("!");
    needSpace = false;
  }
  public void before_cdtext(ClassDict source, Text dest) {
    space();
    out.print("{{" + source.get_cdtext() + "}" + "}");
    needSpace = true;
  }
  public void before_strategy(StrategyExpr source, String dest) {
    space();
    out.print("\"" + source.get_strategy() + "\"");
    needSpace = true;
  }
  public void before_name(TraversalName source, Ident dest) {
    space();
    out.print(source.get_name());
    needSpace = true;
  }
  public void before_name(SelectorName source, Ident dest) {
    space();
    out.print(source.get_name());
    needSpace = true;
  }
  public void before_name(StrategyName source, Ident dest) {
    space();
    out.print(source.get_name());
    needSpace = true;
  }
  public void before_name(NodeSubsetName source, Ident dest) {
    space();
    out.print(source.get_name());
    needSpace = true;
  }
  public void before_name(ClassDictionaryName source, Ident dest) {
    space();
    out.print(source.get_name());
    needSpace = true;
  }
  public void before_names(CDVisitor source, Vector dest) {
    space();
    out.print(source.get_names());
    needSpace = true;
  }
  public void before_cgs(CDVisitor source, Vector dest) {
    space();
    out.print(source.get_cgs());
    needSpace = true;
  }
  public void before_errors(CDVisitor source, String dest) {
    space();
    out.print("\"" + source.get_errors() + "\"");
    needSpace = true;
  }
  public void before_cg(CDefVisitor source, ClassGraph dest) {
    space();
    out.print(source.get_cg());
    needSpace = true;
  }
  public void before_cdname(CDefVisitor source, Ident dest) {
    space();
    out.print(source.get_cdname());
    needSpace = true;
  }
  public void before_errors(CDefVisitor source, String dest) {
    space();
    out.print("\"" + source.get_errors() + "\"");
    needSpace = true;
  }
  public void before_names(SelVisitor source, Vector dest) {
    space();
    out.print(source.get_names());
    needSpace = true;
  }
  public void before_cgs(SelVisitor source, Vector dest) {
    space();
    out.print(source.get_cgs());
    needSpace = true;
  }
  public void before_errors(SelVisitor source, String dest) {
    space();
    out.print("\"" + source.get_errors() + "\"");
    needSpace = true;
  }
  public void before_cg(SVisitor source, ClassGraph dest) {
    space();
    out.print(source.get_cg());
    needSpace = true;
  }
  public void before_errors(SVisitor source, String dest) {
    space();
    out.print("\"" + source.get_errors() + "\"");
    needSpace = true;
  }
  public void before_cdname(NSVisitor source, String dest) {
    space();
    out.print("\"" + source.get_cdname() + "\"");
    needSpace = true;
  }
  public void before_cg(NSVisitor source, ClassGraph dest) {
    space();
    out.print(source.get_cg());
    needSpace = true;
  }
  public void before_errors(NSVisitor source, String dest) {
    space();
    out.print("\"" + source.get_errors() + "\"");
    needSpace = true;
  }
  public void before_indent(PrintVisitor source, int dest) {
    space();
    out.print(source.get_indent());
    needSpace = true;
  }
  public void before_needSpace(PrintVisitor source, boolean dest) {
    space();
    out.print(source.get_needSpace());
    needSpace = true;
  }
  public void before_copy(CopyVisitor source, Object dest) {
    space();
    out.print(source.get_copy());
    needSpace = true;
  }
  public void before_is_equal(SubgraphVisitor source, boolean dest) {
    space();
    out.print(source.get_is_equal());
    needSpace = true;
  }
  public void before_is_equal(EqualVisitor source, boolean dest) {
    space();
    out.print(source.get_is_equal());
    needSpace = true;
  }
  public void before_indent(DisplayVisitor source, int dest) {
    space();
    out.print(source.get_indent());
    needSpace = true;
  }
  public void before_indent(TraceVisitor source, int dest) {
    space();
    out.print(source.get_indent());
    needSpace = true;
  }
  public void before_first(NodeSubsetExpression_PCList source, Nonempty_NodeSubsetExpression_PCList dest) {
    out.print("(");
    needSpace = false;
  }
  public void after_first(NodeSubsetExpression_PCList source, Nonempty_NodeSubsetExpression_PCList dest) {
    out.print(")");
    needSpace = false;
  }
  public void before_first(ClassName_BCList source, Nonempty_ClassName_BCList dest) {
    out.print("{");
    needSpace = false;
  }
  public void after_first(ClassName_BCList source, Nonempty_ClassName_BCList dest) {
    out.print("}");
    needSpace = false;
  }
  public void before_it(Nonempty_Name source, Ident dest) {
    space();
    out.print(source.get_it());
    needSpace = true;
  }
  public void before_next(Nonempty_Name source, Nonempty_Name dest) {
    out.print(".");
    needSpace = false;
  }
  public void before_next(Nonempty_AspectLanguage_List source, Nonempty_AspectLanguage_List dest) {
    out.print(" ");
    needSpace = false;
  }
  public void before_next(Nonempty_StrategyDef_List source, Nonempty_StrategyDef_List dest) {
    out.print(" ");
    needSpace = false;
  }
  public void before_next(Nonempty_NodeSubsetDef_List source, Nonempty_NodeSubsetDef_List dest) {
    out.print(" ");
    needSpace = false;
  }
  public void before_next(Nonempty_NodeSubsetExpression_PCList source, Nonempty_NodeSubsetExpression_PCList dest) {
    out.print(",");
    needSpace = false;
  }
  public void before_next(Nonempty_ClassName_BCList source, Nonempty_ClassName_BCList dest) {
    out.print(",");
    needSpace = false;
  }
  void universal_trv0_bef(UniversalVisitor _v_) {
    super.universal_trv0_bef(_v_);
  }

  void universal_trv0_aft(UniversalVisitor _v_) {
    super.universal_trv0_aft(_v_);
  }

  void universal_trv0(UniversalVisitor _v_) {
    universal_trv0_bef(_v_);
    super.universal_trv0(_v_);
    universal_trv0_aft(_v_);
  }

}
