package jseifried.xaspecteditor.dj;
import java.util.Vector;

import edu.neu.ccs.demeter.Ident;
import edu.neu.ccs.demeter.Text;
import edu.neu.ccs.demeter.aplib.cd.ClassGraph;
class DisplayVisitor extends UniversalVisitor {
  protected int indent;
  public int get_indent() { return indent; }
  public void set_indent(int new_indent) { indent = new_indent; }
  public DisplayVisitor() { super(); }
  public DisplayVisitor(int indent) {
    super();
    set_indent(indent);
  }

    protected java.io.PrintWriter out = new java.io.PrintWriter(System.out, true);
    java.io.PrintWriter get_out()             { return out; }
    void set_out(java.io.PrintWriter new_out) { out = new_out; }
    DisplayVisitor(java.io.PrintWriter out)     { set_out(out); }
    DisplayVisitor(java.io.PrintStream out)
      { set_out(new java.io.PrintWriter(out, true)); }
  
  public void finish() { out.flush(); }
  public void before(XAspectLanguage host) {
    out.print(": XAspectLanguage  (");
    indent++;
  }
  public void after(XAspectLanguage host) {
    out.print(" )");
    indent--;
  }
  public void before_aspectlanguage_list(XAspectLanguage source, AspectLanguage_List dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<aspectlanguage_list> ");
  }
  public void before(ClassDictionaryL host) {
    out.print(": ClassDictionaryL  (");
    indent++;
  }
  public void after(ClassDictionaryL host) {
    out.print(" )");
    indent--;
  }
  public void before_classdictionaryname(ClassDictionaryL source, ClassDictionaryName dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<classdictionaryname> ");
  }
  public void before_classdict(ClassDictionaryL source, ClassDict dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<classdict> ");
  }
  public void before(SelectorL host) {
    out.print(": SelectorL  (");
    indent++;
  }
  public void after(SelectorL host) {
    out.print(" )");
    indent--;
  }
  public void before_traversalname(SelectorL source, TraversalName dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<traversalname> ");
  }
  public void before_strategydef_list(SelectorL source, StrategyDef_List dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<strategydef_list> ");
  }
  public void before_nodesubsetdef_list(SelectorL source, NodeSubsetDef_List dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<nodesubsetdef_list> ");
  }
  public void before_selectorname(SelectorL source, SelectorName dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<selectorname> ");
  }
  public void before_classdictionaryname(SelectorL source, ClassDictionaryName dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<classdictionaryname> ");
  }
  public void before(StrategyDef host) {
    out.print(": StrategyDef  (");
    indent++;
  }
  public void after(StrategyDef host) {
    out.print(" )");
    indent--;
  }
  public void before_strategyname(StrategyDef source, StrategyName dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<strategyname> ");
  }
  public void before_strategyexpr(StrategyDef source, StrategyExpr dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<strategyexpr> ");
  }
  public void before(NodeSubsetDef host) {
    out.print(": NodeSubsetDef  (");
    indent++;
  }
  public void after(NodeSubsetDef host) {
    out.print(" )");
    indent--;
  }
  public void before_nodesubsetname(NodeSubsetDef source, NodeSubsetName dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<nodesubsetname> ");
  }
  public void before_nodesubsetexpression(NodeSubsetDef source, NodeSubsetExpression dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<nodesubsetexpression> ");
  }
  public void before(BCompound host) {
    out.print(": BCompound  (");
    indent++;
  }
  public void after(BCompound host) {
    out.print(" )");
    indent--;
  }
  public void before_op(BCompound source, BinaryOp dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<op> ");
  }
  public void before_args(BCompound source, NodeSubsetExpression_PCList dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<args> ");
  }
  public void before(UCompound host) {
    out.print(": UCompound  (");
    indent++;
  }
  public void after(UCompound host) {
    out.print(" )");
    indent--;
  }
  public void before_op(UCompound source, UnaryOp dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<op> ");
  }
  public void before_arg(UCompound source, NodeSubsetExpression dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<arg> ");
  }
  public void before(ClassNameSet host) {
    out.print(": ClassNameSet  (");
    indent++;
  }
  public void after(ClassNameSet host) {
    out.print(" )");
    indent--;
  }
  public void before_classname_bclist(ClassNameSet source, ClassName_BCList dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<classname_bclist> ");
  }
  public void before(GraphNodes host) {
    out.print(": GraphNodes  (");
    indent++;
  }
  public void after(GraphNodes host) {
    out.print(" )");
    indent--;
  }
  public void before_strategyname(GraphNodes source, StrategyName dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<strategyname> ");
  }
  public void before(GraphNodeRegExp host) {
    out.print(": GraphNodeRegExp  (");
    indent++;
  }
  public void after(GraphNodeRegExp host) {
    out.print(" )");
    indent--;
  }
  public void before_classname(GraphNodeRegExp source, ClassName dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<classname> ");
  }
  public void before_wildcard(GraphNodeRegExp source, WildCard dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<wildcard> ");
  }
  public void before(WildCard host) {
    out.print(": WildCard  (");
    indent++;
  }
  public void after(WildCard host) {
    out.print(" )");
    indent--;
  }
  public void before(Union host) {
    out.print(": Union  (");
    indent++;
  }
  public void after(Union host) {
    out.print(" )");
    indent--;
  }
  public void before(Intersection host) {
    out.print(": Intersection  (");
    indent++;
  }
  public void after(Intersection host) {
    out.print(" )");
    indent--;
  }
  public void before(Complement host) {
    out.print(": Complement  (");
    indent++;
  }
  public void after(Complement host) {
    out.print(" )");
    indent--;
  }
  public void before(ClassDict host) {
    out.print(": ClassDict  (");
    indent++;
  }
  public void after(ClassDict host) {
    out.print(" )");
    indent--;
  }
  public void before_cdtext(ClassDict source, Text dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<cdtext> ");
    out.print(" : Text");
    out.print(" {{" + source.get_cdtext() + "}" + "}" + " ");
  }
  public void before(StrategyExpr host) {
    out.print(": StrategyExpr  (");
    indent++;
  }
  public void after(StrategyExpr host) {
    out.print(" )");
    indent--;
  }
  public void before_strategy(StrategyExpr source, String dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<strategy> ");
    out.print(" : String");
    out.print(" \"" + source.get_strategy() + "\" ");
  }
  public void before(ClassName host) {
    out.print(": ClassName  (");
    indent++;
  }
  public void after(ClassName host) {
    out.print(" )");
    indent--;
  }
  public void before_name(ClassName source, Name dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<name> ");
  }
  public void before(Name host) {
    out.print(": Name  {");
    indent++;
  }
  public void after(Name host) {
    out.print(" }");
    indent--;
  }
  public void before_first(Name source, Nonempty_Name dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<first> ");
  }
  public void before(TraversalName host) {
    out.print(": TraversalName  (");
    indent++;
  }
  public void after(TraversalName host) {
    out.print(" )");
    indent--;
  }
  public void before_name(TraversalName source, Ident dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<name> ");
    out.print(" : Ident");
    out.print(" \"" + source.get_name() + "\"");
  }
  public void before(SelectorName host) {
    out.print(": SelectorName  (");
    indent++;
  }
  public void after(SelectorName host) {
    out.print(" )");
    indent--;
  }
  public void before_name(SelectorName source, Ident dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<name> ");
    out.print(" : Ident");
    out.print(" \"" + source.get_name() + "\"");
  }
  public void before(StrategyName host) {
    out.print(": StrategyName  (");
    indent++;
  }
  public void after(StrategyName host) {
    out.print(" )");
    indent--;
  }
  public void before_name(StrategyName source, Ident dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<name> ");
    out.print(" : Ident");
    out.print(" \"" + source.get_name() + "\"");
  }
  public void before(NodeSubsetName host) {
    out.print(": NodeSubsetName  (");
    indent++;
  }
  public void after(NodeSubsetName host) {
    out.print(" )");
    indent--;
  }
  public void before_name(NodeSubsetName source, Ident dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<name> ");
    out.print(" : Ident");
    out.print(" \"" + source.get_name() + "\"");
  }
  public void before(ClassDictionaryName host) {
    out.print(": ClassDictionaryName  (");
    indent++;
  }
  public void after(ClassDictionaryName host) {
    out.print(" )");
    indent--;
  }
  public void before_name(ClassDictionaryName source, Ident dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<name> ");
    out.print(" : Ident");
    out.print(" \"" + source.get_name() + "\"");
  }
  public void before(CDVisitor host) {
    out.print(": CDVisitor  (");
    indent++;
  }
  public void after(CDVisitor host) {
    out.print(" )");
    indent--;
  }
  public void before_xal(CDVisitor source, XAspectLanguage dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<xal> ");
  }
  public void before_names(CDVisitor source, Vector dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<names> ");
  }
  public void before_cgs(CDVisitor source, Vector dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<cgs> ");
  }
  public void before_errors(CDVisitor source, String dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<errors> ");
    out.print(" : String");
    out.print(" \"" + source.get_errors() + "\" ");
  }
  public void before(CDefVisitor host) {
    out.print(": CDefVisitor  (");
    indent++;
  }
  public void after(CDefVisitor host) {
    out.print(" )");
    indent--;
  }
  public void before_cg(CDefVisitor source, ClassGraph dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<cg> ");
  }
  public void before_cdname(CDefVisitor source, Ident dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<cdname> ");
    out.print(" : Ident");
    out.print(" \"" + source.get_cdname() + "\"");
  }
  public void before_errors(CDefVisitor source, String dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<errors> ");
    out.print(" : String");
    out.print(" \"" + source.get_errors() + "\" ");
  }
  public void before(SelVisitor host) {
    out.print(": SelVisitor  (");
    indent++;
  }
  public void after(SelVisitor host) {
    out.print(" )");
    indent--;
  }
  public void before_names(SelVisitor source, Vector dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<names> ");
  }
  public void before_cgs(SelVisitor source, Vector dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<cgs> ");
  }
  public void before_errors(SelVisitor source, String dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<errors> ");
    out.print(" : String");
    out.print(" \"" + source.get_errors() + "\" ");
  }
  public void before(SVisitor host) {
    out.print(": SVisitor  (");
    indent++;
  }
  public void after(SVisitor host) {
    out.print(" )");
    indent--;
  }
  public void before_cg(SVisitor source, ClassGraph dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<cg> ");
  }
  public void before_errors(SVisitor source, String dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<errors> ");
    out.print(" : String");
    out.print(" \"" + source.get_errors() + "\" ");
  }
  public void before(NSVisitor host) {
    out.print(": NSVisitor  (");
    indent++;
  }
  public void after(NSVisitor host) {
    out.print(" )");
    indent--;
  }
  public void before_cdname(NSVisitor source, String dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<cdname> ");
    out.print(" : String");
    out.print(" \"" + source.get_cdname() + "\" ");
  }
  public void before_cg(NSVisitor source, ClassGraph dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<cg> ");
  }
  public void before_errors(NSVisitor source, String dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<errors> ");
    out.print(" : String");
    out.print(" \"" + source.get_errors() + "\" ");
  }
  public void before(Main host) {
    out.print(": Main  (");
    indent++;
  }
  public void after(Main host) {
    out.print(" )");
    indent--;
  }
  public void before(PrintVisitor host) {
    out.print(": PrintVisitor  (");
    indent++;
  }
  public void after(PrintVisitor host) {
    out.print(" )");
    indent--;
  }
  public void before_indent(PrintVisitor source, int dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<indent> ");
    out.print(" : int \"" + dest + "\"");
  }
  public void before_needSpace(PrintVisitor source, boolean dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<needSpace> ");
    out.print(" : boolean \"" + dest + "\"");
  }
  public void before(CopyVisitor host) {
    out.print(": CopyVisitor  (");
    indent++;
  }
  public void after(CopyVisitor host) {
    out.print(" )");
    indent--;
  }
  public void before_copy(CopyVisitor source, Object dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<copy> ");
  }
  public void before(SubgraphVisitor host) {
    out.print(": SubgraphVisitor  (");
    indent++;
  }
  public void after(SubgraphVisitor host) {
    out.print(" )");
    indent--;
  }
  public void before_is_equal(SubgraphVisitor source, boolean dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<is_equal> ");
    out.print(" : boolean \"" + dest + "\"");
  }
  public void before(EqualVisitor host) {
    out.print(": EqualVisitor  (");
    indent++;
  }
  public void after(EqualVisitor host) {
    out.print(" )");
    indent--;
  }
  public void before_is_equal(EqualVisitor source, boolean dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<is_equal> ");
    out.print(" : boolean \"" + dest + "\"");
  }
  public void before(DisplayVisitor host) {
    out.print(": DisplayVisitor  (");
    indent++;
  }
  public void after(DisplayVisitor host) {
    out.print(" )");
    indent--;
  }
  public void before_indent(DisplayVisitor source, int dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<indent> ");
    out.print(" : int \"" + dest + "\"");
  }
  public void before(TraceVisitor host) {
    out.print(": TraceVisitor  (");
    indent++;
  }
  public void after(TraceVisitor host) {
    out.print(" )");
    indent--;
  }
  public void before_indent(TraceVisitor source, int dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<indent> ");
    out.print(" : int \"" + dest + "\"");
  }
  public void before(AspectLanguage_List host) {
    out.print(": AspectLanguage_List  {");
    indent++;
  }
  public void after(AspectLanguage_List host) {
    out.print(" }");
    indent--;
  }
  public void before_first(AspectLanguage_List source, Nonempty_AspectLanguage_List dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<first> ");
  }
  public void before(StrategyDef_List host) {
    out.print(": StrategyDef_List  {");
    indent++;
  }
  public void after(StrategyDef_List host) {
    out.print(" }");
    indent--;
  }
  public void before_first(StrategyDef_List source, Nonempty_StrategyDef_List dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<first> ");
  }
  public void before(NodeSubsetDef_List host) {
    out.print(": NodeSubsetDef_List  {");
    indent++;
  }
  public void after(NodeSubsetDef_List host) {
    out.print(" }");
    indent--;
  }
  public void before_first(NodeSubsetDef_List source, Nonempty_NodeSubsetDef_List dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<first> ");
  }
  public void before(NodeSubsetExpression_PCList host) {
    out.print(": NodeSubsetExpression_PCList  {");
    indent++;
  }
  public void after(NodeSubsetExpression_PCList host) {
    out.print(" }");
    indent--;
  }
  public void before_first(NodeSubsetExpression_PCList source, Nonempty_NodeSubsetExpression_PCList dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<first> ");
  }
  public void before(ClassName_BCList host) {
    out.print(": ClassName_BCList  {");
    indent++;
  }
  public void after(ClassName_BCList host) {
    out.print(" }");
    indent--;
  }
  public void before_first(ClassName_BCList source, Nonempty_ClassName_BCList dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<first> ");
  }
  public void before(Nonempty_Name host) {
    out.print(": Nonempty_Name  (");
    indent++;
  }
  public void after(Nonempty_Name host) {
    out.print(" )");
    indent--;
  }
  public void before_it(Nonempty_Name source, Ident dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<it> ");
    out.print(" : Ident");
    out.print(" \"" + source.get_it() + "\"");
  }
  public void before_next(Nonempty_Name source, Nonempty_Name dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<next> ");
  }
  public void before(Nonempty_AspectLanguage_List host) {
    out.print(": Nonempty_AspectLanguage_List  (");
    indent++;
  }
  public void after(Nonempty_AspectLanguage_List host) {
    out.print(" )");
    indent--;
  }
  public void before_it(Nonempty_AspectLanguage_List source, AspectLanguage dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<it> ");
  }
  public void before_next(Nonempty_AspectLanguage_List source, Nonempty_AspectLanguage_List dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<next> ");
  }
  public void before(Nonempty_StrategyDef_List host) {
    out.print(": Nonempty_StrategyDef_List  (");
    indent++;
  }
  public void after(Nonempty_StrategyDef_List host) {
    out.print(" )");
    indent--;
  }
  public void before_it(Nonempty_StrategyDef_List source, StrategyDef dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<it> ");
  }
  public void before_next(Nonempty_StrategyDef_List source, Nonempty_StrategyDef_List dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<next> ");
  }
  public void before(Nonempty_NodeSubsetDef_List host) {
    out.print(": Nonempty_NodeSubsetDef_List  (");
    indent++;
  }
  public void after(Nonempty_NodeSubsetDef_List host) {
    out.print(" )");
    indent--;
  }
  public void before_it(Nonempty_NodeSubsetDef_List source, NodeSubsetDef dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<it> ");
  }
  public void before_next(Nonempty_NodeSubsetDef_List source, Nonempty_NodeSubsetDef_List dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<next> ");
  }
  public void before(Nonempty_NodeSubsetExpression_PCList host) {
    out.print(": Nonempty_NodeSubsetExpression_PCList  (");
    indent++;
  }
  public void after(Nonempty_NodeSubsetExpression_PCList host) {
    out.print(" )");
    indent--;
  }
  public void before_it(Nonempty_NodeSubsetExpression_PCList source, NodeSubsetExpression dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<it> ");
  }
  public void before_next(Nonempty_NodeSubsetExpression_PCList source, Nonempty_NodeSubsetExpression_PCList dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<next> ");
  }
  public void before(Nonempty_ClassName_BCList host) {
    out.print(": Nonempty_ClassName_BCList  (");
    indent++;
  }
  public void after(Nonempty_ClassName_BCList host) {
    out.print(" )");
    indent--;
  }
  public void before_it(Nonempty_ClassName_BCList source, ClassName dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<it> ");
  }
  public void before_next(Nonempty_ClassName_BCList source, Nonempty_ClassName_BCList dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<next> ");
  }
  void universal_trv0_bef(UniversalVisitor _v_) {
    super.universal_trv0_bef(_v_);
  }

  void universal_trv0_aft(UniversalVisitor _v_) {
    super.universal_trv0_aft(_v_);
  }

  void universal_trv0(UniversalVisitor _v_) {
    universal_trv0_bef(_v_);
    super.universal_trv0(_v_);
    universal_trv0_aft(_v_);
  }

}
