/*
 * Decompiled with CFR 0.152.
 */
package CSU670_Plugin.editors;

import CSU670_Plugin.actions.AspectXSyntaxHighlight;
import CSU670_Plugin.gen.Main;
import edu.neu.ccs.demeter.aplib.EdgeI;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.FindReplaceDocumentAdapter;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.swt.graphics.Color;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.editors.text.TextFileDocumentProvider;
import org.eclipse.ui.texteditor.IDocumentProvider;

public class AspectXEditor
extends TextEditor {
    public static AspectXEditor current = null;
    public static int editorCount = 0;

    public AspectXEditor() {
        current = this;
        ++editorCount;
        this.setDocumentProvider((IDocumentProvider)new TextFileDocumentProvider());
    }

    public void dispose() {
        if (current == this) {
            current = null;
        }
        --editorCount;
        super.dispose();
    }

    public String getText() {
        return this.getDocument().get();
    }

    public IDocument getDocument() {
        return this.getDocumentProvider().getDocument((Object)this.getEditorInput());
    }

    public String getCursorPosition() {
        return super.getCursorPosition();
    }

    public void highlight(Color c, int start, int len) {
        this.getSourceViewer().setTextColor(c, start, len, false);
    }

    public void highlight(Color c, IRegion r) {
        this.highlight(c, r.getOffset(), r.getLength());
    }

    public void unhighlight() {
        this.highlight(AspectXSyntaxHighlight.black, 0, this.getDocument().getLength());
    }

    public String currentStrategy() throws Exception {
        FindReplaceDocumentAdapter f = new FindReplaceDocumentAdapter(this.getDocument());
        String[] p = current.getCursorPosition().split(":");
        int col = Integer.parseInt(p[0].trim()) - 1;
        int row = Integer.parseInt(p[1].trim()) - 1;
        int pos = this.getDocument().getLineOffset(col) + row;
        IRegion region = f.find(pos, "declare", false, false, true, false);
        if (region == null) {
            return "";
        }
        if ((region = f.find(region.getOffset(), "declare[^:;]+:[^:;]+:[^;]+;", true, false, false, true)) == null) {
            return "";
        }
        if (region.getOffset() > pos || region.getOffset() + region.getLength() < pos) {
            return "";
        }
        current.highlight(AspectXSyntaxHighlight.magenta, region);
        String strategy = f.subSequence(region.getOffset(), region.getOffset() + region.getLength()).toString();
        strategy = strategy.substring(strategy.indexOf(":") + 1);
        strategy = strategy.substring(0, strategy.indexOf(":"));
        return strategy.trim();
    }

    public void handleCursorPositionChanged() {
        if (!Main.hadERROR) {
            this.unhighlight();
            AspectXSyntaxHighlight.instance.highlightKeywords();
            AspectXSyntaxHighlight.instance.run(null);
        }
    }

    public void highlightNode(Color c, String s) throws BadLocationException {
        FindReplaceDocumentAdapter f = new FindReplaceDocumentAdapter(this.getDocument());
        IRegion region = f.find(0, "{{", true, false, false, false);
        region = f.find(region.getOffset(), "\\b" + s + "[^=a-zA-Z]*=", true, true, false, true);
        this.highlight(c, region.getOffset(), s.length());
    }

    public void highlightEdge(Color c, EdgeI e) throws BadLocationException {
        FindReplaceDocumentAdapter f = new FindReplaceDocumentAdapter(this.getDocument());
        IRegion region1 = f.find(0, "{{", true, false, false, false);
        IRegion region2 = f.find((region1 = f.find(region1.getOffset(), "\\b" + e.getSource() + "[^=a-zA-Z]*=[^;]+;", true, true, false, true)).getOffset(), "<\\s*" + e.getLabel() + "\\s*>\\s*" + e.getTarget() + "\\b", true, true, false, true);
        if (region2 == null) {
            region2 = f.find(region1.getOffset(), e.getTarget().toString(), true, true, true, false);
        }
        if (region2 == null) {
            return;
        }
        if (region2.getOffset() > region1.getOffset() + region1.getLength()) {
            return;
        }
        this.highlight(c, region2);
    }

    protected void updateContentDependentActions() {
        super.updateContentDependentActions();
        Main.hadERROR = true;
        Main.userCg = null;
        this.unhighlight();
        AspectXSyntaxHighlight.instance.highlightKeywords();
    }
}

