/*
 * Decompiled with CFR 0.152.
 */
package CSU670_Plugin.actions;

import CSU670_Plugin.TraversalHighlight;
import CSU670_Plugin.editors.AspectXEditor;
import CSU670_Plugin.gen.Main;
import edu.neu.ccs.demeter.aplib.EdgeI;
import java.util.Iterator;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.FindReplaceDocumentAdapter;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public class AspectXSyntaxHighlight
implements IWorkbenchWindowActionDelegate {
    public static final Color red = new Color((Device)Display.getCurrent(), 255, 0, 0);
    public static final Color green = new Color((Device)Display.getCurrent(), 0, 255, 0);
    public static final Color blue = new Color((Device)Display.getCurrent(), 0, 0, 255);
    public static final Color cyan = new Color((Device)Display.getCurrent(), 0, 255, 255);
    public static final Color magenta = new Color((Device)Display.getCurrent(), 255, 0, 255);
    public static final Color yellow = new Color((Device)Display.getCurrent(), 255, 255, 0);
    public static final Color black = new Color((Device)Display.getCurrent(), 0, 0, 0);
    public static final Color white = new Color((Device)Display.getCurrent(), 255, 255, 255);
    public static final Color grey = new Color((Device)Display.getCurrent(), 150, 150, 150);
    public static AspectXSyntaxHighlight instance = new AspectXSyntaxHighlight();
    private IWorkbenchWindow window;
    private static final String keywordregexp = "[(){}.=;:!,]|\\b(class|dictionary|chosen|selector|aspect|ClassDictionary|Traversal|declare|node|set|strategy|nodes|regexp|and|or|from|to|via|stop|through|bypassing|->)\\b";
    private static final String commentregexp = "//[^\\n]*|/\\*([^*]|\\*[^/])*\\*/";

    public void run(IAction action) {
        String msg = "";
        try {
            if (AspectXEditor.editorCount != 1) {
                msg = String.valueOf(msg) + "Error! Must have exactly one (1) xaj editor\n";
            } else if (AspectXEditor.current == null) {
                msg = String.valueOf(msg) + "Error! Only start one editor xaj per session\n";
            } else if (Main.userCg == null) {
                msg = String.valueOf(msg) + "Error! Must check syntax first";
            } else {
                IDocument doc = AspectXEditor.current.getDocument();
                new FindReplaceDocumentAdapter(doc);
                String strategy = AspectXEditor.current.currentStrategy();
                if (strategy != "") {
                    if (!Main.traversals.containsKey(strategy)) {
                        msg = String.valueOf(msg) + "Unkown strategy " + strategy;
                    } else {
                        TraversalHighlight t = (TraversalHighlight)Main.traversals.get(strategy);
                        Iterator i = t.nodes().iterator();
                        while (i.hasNext()) {
                            AspectXEditor.current.highlightNode(green, (String)i.next());
                        }
                        i = t.edges().iterator();
                        while (i.hasNext()) {
                            AspectXEditor.current.highlightEdge(cyan, (EdgeI)i.next());
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            msg = String.valueOf(msg) + "Exception!!!";
            e.printStackTrace();
            System.out.println(e.getMessage());
        }
        if (msg != "") {
            Main.hadERROR = true;
            MessageDialog.openInformation((Shell)this.window.getShell(), (String)"AspectX Highlight", (String)msg);
        }
    }

    public void highlightKeywords() {
        IDocument doc = AspectXEditor.current.getDocument();
        FindReplaceDocumentAdapter f = new FindReplaceDocumentAdapter(doc);
        try {
            IRegion r;
            int i = 0;
            while (i < f.length() && (r = f.find(i, keywordregexp, true, true, false, true)) != null) {
                AspectXEditor.current.highlight(blue, r);
                i = r.getOffset() + 1;
            }
            i = 0;
            while (i < f.length() && (r = f.find(i, commentregexp, true, true, false, true)) != null) {
                AspectXEditor.current.highlight(grey, r);
                i = r.getOffset() + 1;
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
        this.window = window;
    }
}

