package APStudio.wizards;

import java.lang.reflect.InvocationTargetException;

import org.eclipse.core.resources.*;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.jface.operation.IRunnableWithProgress;

import org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;

import org.eclipse.jdt.ui.wizards.NewJavaProjectWizardPage;

import APStudio.APStudioPlugin;

/**
 * This is a sample new wizard. Its role is to create a new file 
 * resource in the provided container. If the container resource
 * (a folder or a project) is selected in the workspace 
 * when the wizard is opened, it will accept it as the target
 * container. The wizard creates one file with the extension
 * "mpe". If a sample multi-page editor (also available
 * as a template) is registered for the same extension, it will
 * be able to open it.
 */

public class APStudioProjectNewWizard
	extends BasicNewProjectResourceWizard
	implements IExecutableExtension {

	private NewJavaProjectWizardPage fJavaPage;
	private WizardNewProjectCreationPage fMainPage;
	private IConfigurationElement fConfigElement;

	/**
	 * Constructor for DAJProjectNewWizard.
	 */
	public APStudioProjectNewWizard() {
		super();
		//setDefaultPageImageDescriptor(JavaPluginImages.DESC_WIZBAN_NEWJPRJ);
		//setDialogSettings(AspectJPlugin.getDefault().getDialogSettings());
		setWindowTitle("New DAJ Project");
	}
	
	/**
	 * Adding the page to the wizard.
	 */

	public void addPages() {
		
		fMainPage = new WizardNewProjectCreationPage("NewDajProjectCreationWizard");
		
		fMainPage.setTitle("New DAJ Project");
		fMainPage.setDescription("This wizard creates a new DAJ project");
		
		addPage(fMainPage);
		IWorkspaceRoot root = APStudioPlugin.getWorkspace().getRoot();
		fJavaPage = new NewJavaProjectWizardPage(root, fMainPage);
		addPage(fJavaPage);
	}

	/**
	 * This method is called when 'Finish' button is pressed in
	 * the wizard. We will create an operation and run it
	 * using wizard as execution context.
	 */
	public boolean performFinish() {
		IRunnableWithProgress op =
			new WorkspaceModifyDelegatingOperation(fJavaPage.getRunnable());
		try {
			getContainer().run(false, true, op);
		} catch (InvocationTargetException e) {
			/*String title =
				AspectJPlugin.getResourceString("NewAspectjProjectCreationWizard.op_error.title");
			String message =
				AspectJPlugin.getResourceString("NewAspectjProjectCreationWizard.op_error.message");
			ExceptionHandler.handle(e, getShell(), title, message);*/
	
			return false;
		} catch (InterruptedException e) {
			return false;
		}
		BasicNewProjectResourceWizard.updatePerspective(fConfigElement);

		IProject project = fJavaPage.getNewJavaProject().getProject();

		APStudioPlugin.getDefault().setCurrentProject( project );
		selectAndReveal(project);

		try {
			IProjectDescription projectDescription = project.getDescription();
			project.setDescription(projectDescription, null);
//			// The nature to add is the PluginID+NatureID - it is not the
//			// name of the class implementing IProjectNature !!
//
//			String[] natures = projectDescription.getNatureIds();
//			String[] newNatures = new String[natures.length + 1];
//			System.arraycopy(natures, 0, newNatures, 0, natures.length);
//			newNatures[natures.length] = DajPlugin.ID_NATURE; 
//			projectDescription.setNatureIds(newNatures);
			
//			
//			// When the nature is attached, the project will be driven through
//			// INatureProject.configure() which will replace the normal javabuilder
//			// with the daj builder.
			
		} catch (Throwable e) {
			System.out.println("> Error creating new project: " + e);
			e.printStackTrace();
		}

		return true;
	}
	
	public void setInitializationData(
		IConfigurationElement cfig,
		String propertyName,
		Object data) {
		fConfigElement = cfig;
	}

}