/*******************************************************************************
 * Copyright (c) 2000, 2003 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package APStudio.models.commands;

import org.eclipse.gef.commands.Command;

import APStudio.models.ClassDiagramModel;

public class LogicLabelCommand
	extends Command
{

private String newName, oldName;
private ClassDiagramModel label;

public LogicLabelCommand(ClassDiagramModel l, String s) {
	label = l;
	if (s != null)
		newName = s;
	else
		newName = "";  //$NON-NLS-1$
}

public void execute() {
	oldName = label.getName();
	label.setName(newName);
}

public void undo() {
	label.setName(oldName);
}

}
