/*******************************************************************************
 * Copyright (c) 2000, 2003 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package APStudio.models.commands;
import APStudio.models.ConnectorBendpoint;

public class CreateBendpointCommand 
	extends BendpointCommand 
{

public void execute() {
	ConnectorBendpoint wbp = new ConnectorBendpoint();
	wbp.setRelativeDimensions(getFirstRelativeDimension(), 
					getSecondRelativeDimension());
	getConnector().insertBendpoint(getIndex(), wbp);
	super.execute();
}

public void undo() {
	super.undo();
	getConnector().removeBendpoint(getIndex());
}

}


