/*******************************************************************************
 * Copyright (c) 2000, 2003 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package APStudio.models.commands;

import org.eclipse.gef.commands.Command;
import APStudio.models.Connector;
import APStudio.models.BasicSubpart;
import APStudio.ResourceMgtUtils;

public class ConnectionCommand
	extends Command
{

protected BasicSubpart oldSource;
protected String oldSourceTerminal;
protected BasicSubpart oldTarget;
protected String oldTargetTerminal;
protected BasicSubpart source;
protected String sourceTerminal;
protected BasicSubpart target; 
protected String targetTerminal; 
protected Connector conn;

public ConnectionCommand() {
	super("ConnectionCommand");
}

public boolean canExecute(){
	return true;
}

public void execute() {
	if (source != null){
		conn.detachSource();
		conn.setSource(source);
		conn.setSourceTerminal(sourceTerminal);
		conn.attachSource();
	}
	if (target != null) {
		conn.detachTarget();
		conn.setTarget(target);
		conn.setTargetTerminal(targetTerminal);
		conn.attachTarget();
	}
	if(source!=null && target!=null){
		
		
		ResourceMgtUtils.appendContents(source.getName(),target.getName(),conn.getName());
	}
	
	
	if (source == null && target == null){
		conn.detachSource();
		conn.detachTarget();
		conn.setTarget(null);
		conn.setSource(null);
		
	}
}

public String getLabel() {
	return "This is a Connection command";
}

public BasicSubpart getSource() {
	return source;
}

public String getSourceTerminal() {
	return sourceTerminal;
}

public BasicSubpart getTarget() {
	return target;
}

public String getTargetTerminal() {
	return targetTerminal;
}

public Connector getConnector() {
	return conn;
}

public void redo() { 
	execute(); 
}

public void setSource(BasicSubpart newSource) {
	source = newSource;
}

public void setSourceTerminal(String newSourceTerminal) {
	sourceTerminal = newSourceTerminal;
}

public void setTarget(BasicSubpart newTarget) {
	target = newTarget;
}

public void setTargetTerminal(String newTargetTerminal) {
	targetTerminal = newTargetTerminal;
}

public void setConnector(Connector c) {
	conn = c;
	oldSource = c.getSource();
	oldTarget = c.getTarget();
	oldSourceTerminal = c.getSourceTerminal();
	oldTargetTerminal = c.getTargetTerminal();	
}

public void undo() {
	source = conn.getSource();
	target = conn.getTarget();
	sourceTerminal = conn.getSourceTerminal();
	targetTerminal = conn.getTargetTerminal();

	conn.detachSource();
	conn.detachTarget();

	conn.setSource(oldSource);
	conn.setTarget(oldTarget);
	conn.setSourceTerminal(oldSourceTerminal);
	conn.setTargetTerminal(oldTargetTerminal);

	conn.attachSource();
	conn.attachTarget();
}

}
