/*******************************************************************************
 * Copyright (c) 2000, 2003 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package APStudio.models.commands;

import APStudio.models.BasicSubpart;
import APStudio.models.ClassGraphModel;

public class AddCommand extends
	org.eclipse.gef.commands.Command
{

private BasicSubpart child;
private ClassGraphModel parent;
private int index = -1;

public AddCommand() {
	super("AddCommand");
}

public void execute() {
	if( index < 0 )
		parent.addChild(child);
	else
		parent.addChild(child,index);
}

public ClassGraphModel getParent() {
	return parent;
}

public void redo() {
	if( index < 0 )
		parent.addChild(child);
	else
		parent.addChild(child,index);
}

public void setChild(BasicSubpart subpart) {
	child = subpart;
}

public void setIndex(int i){
	index = i;
}

public void setParent(ClassGraphModel newParent) {
	parent = newParent;
}

public void undo() {
	parent.removeChild(child);
}

}