/*
 * Created on Aug 10, 2003
 *
 * To change the template for this generated file go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
package APStudio.models;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.core.resources.IProject;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.views.properties.ComboBoxPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

import APStudio.APStudioPlugin;
import APStudio.ResourceMgtUtils;
/**
 * @author rajags
 *
 * This is the basic Model which can have other nodes added to it.
 * The same class can be used for future extension if each of the nodes
 * needs to hold others.For example a ClassDiagram holding attributes
 * methods etc... 
 */
public class ClassGraphModel extends BasicSubpart{

	static final long serialVersionUID = 1;
	private static BasicElement _child = null;
	private static int count;
	private static Image LOGIC_ICON = new Image (null,
		ClassGraphModel.class.getResourceAsStream("icons/circuit16.gif")); //$NON-NLS-1$

	protected List children = new ArrayList();
	public static String ID_ROUTER = "router";	//$NON-NLS-1$
	public static String ID_STRATEGY = "Strategy";	//$NON-NLS-1$
	public static Integer ROUTER_MANUAL = new Integer(0);
	public static Integer ROUTER_MANHATTAN = new Integer(1);
	protected Integer connectionRouter = null;
	protected String stratFile= "";
	public ClassGraphModel(){
		size.width = 100;
		size.height= 100;
		location.x = 20;
		location.y = 20;		
	}
	
	public void setChild(BasicElement child){
		_child = child;
	}
	public BasicElement getChild(){
		return _child;
	}
	public void addChild(BasicElement child){
		addChild(child, -1);
	}

	public void addChild(BasicElement child, int index){
		//Upcasting here-not good ....but still
		String name =((BasicSubpart)child).getName();
		if((ResourceMgtUtils.getFolder())==null){
			IProject project = APStudioPlugin.getCurrentProject();
			ResourceMgtUtils.createFolderInProject(project,"javaStuff");
		}
		name = name+".java";
		//Create the file
		ResourceMgtUtils.createFileInFolder(ResourceMgtUtils.getFolder(),name);
		
		if (index >= 0){
			children.add(index,child);
			ResourceMgtUtils.nodeList.add(index,child);
		}else{
			children.add(child);
			ResourceMgtUtils.nodeList.add(child);
		}
		fireStructureChange(NODE_ADDED, child);
	}

	public List getChildren(){
		return children;
	}

	public Integer getConnectionRouter(){
		if(connectionRouter==null)
			connectionRouter = ROUTER_MANHATTAN;
		return connectionRouter;
	}
	
	public Image getIconImage() {
		return LOGIC_ICON;
	}

	public String getNewID() {
		return Integer.toString(count++);
	}
	
	/**
	 * Returns <code>null</code> for this model. Returns
	 * normal descriptors for all subclasses.
	 *
	 * @return  Array of property descriptors.
	 */
	public IPropertyDescriptor[] getPropertyDescriptors() {
		if(getClass().equals(ClassGraphModel.class)){
			ComboBoxPropertyDescriptor cbd = new ComboBoxPropertyDescriptor(
					ID_ROUTER, 
					"ConnectionRouter",
					new String[]{
						"Manual",
						"Manhattan"});
			cbd.setLabelProvider(new ConnectionRouterLabelProvider());
				
			return new IPropertyDescriptor[]{cbd,
				new TextPropertyDescriptor(ID_STRATEGY, "Strategy")};
		}
		return super.getPropertyDescriptors();
	}

	public Object getPropertyValue(Object propName) {
		if(propName.equals(ID_ROUTER))
			return connectionRouter;
		else if (propName.equals(ID_STRATEGY))
 			return stratFile;
		return super.getPropertyValue(propName);
	}

	public void removeChild(BasicElement child){
		children.remove(child);
		//I am making a copy.dont want to break anything
		//in the last moment
		ResourceMgtUtils.nodeList.remove(child);
		fireStructureChange(NODE_REMOVED, child);
	}

	public void setConnectionRouter(Integer router){
		Integer oldConnectionRouter = connectionRouter;
		connectionRouter = router;
		firePropertyChange(ID_ROUTER, oldConnectionRouter, connectionRouter);
	}
	
	public void setStrategyFile(String newfileName){
		String oldstratFile = stratFile;
		stratFile =newfileName;
		firePropertyChange(ID_STRATEGY,oldstratFile,newfileName);
	}
	public void setPropertyValue(Object id, Object value){
		if(ID_ROUTER.equals(id))
			setConnectionRouter((Integer)value);
		else if (ID_STRATEGY.equals(id))
			setStrategyFile((String)value);
		else super.setPropertyValue(id,value);
	}

	public String toString(){
		return "label";
	}

	private class ConnectionRouterLabelProvider 
		extends org.eclipse.jface.viewers.LabelProvider{

		public ConnectionRouterLabelProvider(){
			super();
		}
		public String getText(Object element){
			if(element instanceof Integer){
				Integer integer = (Integer)element;
				if(ROUTER_MANUAL.intValue()==integer.intValue())
					return "Manual";
				if(ROUTER_MANHATTAN.intValue()==integer.intValue())
					return "Manhattan";
			}
			return super.getText(element);
		}

	}
}
