/*******************************************************************************
 * Copyright (c) 2000, 2003 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package APStudio.figures;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;

import APStudio.models.ClassDiagramModel;

public class ClassFigure 
	extends NodeFigure {
	
	private static final Dimension SIZE = new Dimension(30,30);
	/**
	 * Color of the LEDFigure's displayed value
	 */
	public static final Color DISPLAY_TEXT = new Color(null, 120, 50, 50);
	private String className = null;
	private static Point valuePoint = new Point(16, 10);
	private static PointList connector = new PointList();
	private static PointList bottomConnector = new PointList();
	private static Rectangle displayRectangle = new Rectangle(15, 11, 31, 25);
	private static Rectangle displayShadow = new Rectangle(14, 10, 32, 26);
	private static Rectangle displayHighlight = new Rectangle(15, 11, 32, 26);
	private static final int Y1 = 2;
	private static final int Y2 = 44;
public ClassFigure() {

	FixedConnectionAnchor c = new FixedConnectionAnchor(this);
	c.index = 0;
	connectionAnchors.put(ClassDiagramModel.TERMINAL_IN[c.index], c);
	inputConnectionAnchors.addElement(c);	
	c = new FixedConnectionAnchor(this);
	c.index = 0;
	connectionAnchors.put(ClassDiagramModel.TERMINAL_OUT[c.index], c);
	outputConnectionAnchors.addElement(c);

	c = new FixedConnectionAnchor(this);
	c.index = 1;
	connectionAnchors.put(ClassDiagramModel.TERMINAL_IN[c.index], c);
	inputConnectionAnchors.addElement(c);	
	c = new FixedConnectionAnchor(this);
	c.index = 1;
	connectionAnchors.put(ClassDiagramModel.TERMINAL_OUT[c.index], c);
	outputConnectionAnchors.addElement(c);
	
	c = new FixedConnectionAnchor(this);
	c.index = 2;
	connectionAnchors.put(ClassDiagramModel.TERMINAL_IN[c.index], c);
	inputConnectionAnchors.addElement(c);
	c = new FixedConnectionAnchor(this);
	c.index = 2;
	connectionAnchors.put(ClassDiagramModel.TERMINAL_OUT[c.index], c);
	outputConnectionAnchors.addElement(c);

	c = new FixedConnectionAnchor(this);
	c.index = 3;
	connectionAnchors.put(ClassDiagramModel.TERMINAL_IN[c.index], c);
	inputConnectionAnchors.addElement(c);	
	c = new FixedConnectionAnchor(this);
	c.index = 3;
	connectionAnchors.put(ClassDiagramModel.TERMINAL_OUT[c.index], c);
	outputConnectionAnchors.addElement(c);
}

///**
// * @see org.eclipse.draw2d.Figure#getPreferredSize(int, int)
// */
//public Dimension getPreferredSize(int wHint, int hHint) {
//	return SIZE;
//}

public String getText(){
	return className;
}

public void setText(String text){
	className = text;
	repaint();
}

public void setBounds(Rectangle rect) {
	super.setBounds(rect);
}

/**
 * @see org.eclipse.draw2d.Figure#setConstraint(IFigure, Object)
 */
public void setConstraint(IFigure child, Object constraint) {
	super.setConstraint(child, constraint);
}

/**
 * @see org.eclipse.draw2d.Figure#paintFigure(Graphics)
 */
protected void paintFigure(Graphics g) {
	Rectangle r = getBounds().getCopy();
	
	g.fillRectangle(r);
	g.drawLine(r.x, r.y, r.right() - 1, r.y);
	g.drawLine(r.right() - 1, r.y, r.right() - 1, r.bottom() - 1);
	g.drawLine(r.x, r.y, r.x, r.bottom() - 1);
	g.drawLine(r.x, r.bottom() - 1, r.right() - 1, r.bottom() - 1);
	
	//g.fillRectangle(displayRectangle);
	g.translate(r.getLocation());
	// Draw the value
	Point p = new Point(r.x + 5,((r.bottom()-r.y)/2)-5);
	g.setForegroundColor(DISPLAY_TEXT);
	g.drawText(className, valuePoint);
}
}