package APStudio.editparts;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.CompoundBorder;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.gef.AccessibleAnchorProvider;
import org.eclipse.gef.AccessibleEditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.RequestConstants;
import org.eclipse.gef.tools.DirectEditManager;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;

import APStudio.ResourceMgtUtils;
import APStudio.figures.ClassFigure;
import APStudio.figures.FigureFactory;
import APStudio.models.ClassDiagramModel;

/**
 * 
 * @author srajagop
 *
 * Manages the construction class
 */
public class ClassEditPart
	extends AbstractAPEditPart
{

/**
 * 
 */	
protected AccessibleEditPart createAccessible() {
	System.out.println("ClassEditpart createAccessible");
	return new AccessibleGraphicalEditPart(){
		public void getValue(AccessibleControlEvent e) {
			e.result = getClassDiagramModel().getName();
		}

		public void getName(AccessibleEvent e) {
			e.result = "Class";
					}
	};
}

private DirectEditManager manager;
public static final Color
	dead = new Color(Display.getDefault(),255,0,0),
	alive  = new Color(Display.getDefault(),0,0,0);

private static Border BORDER = new CompoundBorder(
	new LineBorder(),
	new MarginBorder(2)
);

/**
 * Indicate the edit policies
 */
protected void createEditPolicies(){
	System.out.println("ClassEditpart createEditPolicy");
	super.createEditPolicies();		
	installEditPolicy(EditPolicy.DIRECT_EDIT_ROLE, new LabelDirectEditPolicy());
	installEditPolicy(EditPolicy.COMPONENT_ROLE,new LogicLabelEditPolicy()); 
}
/**
 * Responsible to create the class Figure
 */
protected IFigure createFigure() {
	System.out.println("ClassEditpart getFig");
	return FigureFactory.createNewClass();
}

public Object getAdapter(Class key) {
	if (key == AccessibleAnchorProvider.class)
		return new DefaultAccessibleAnchorProvider() { 
			public List getSourceAnchorLocations() {
				List list = new ArrayList();
				Vector sourceAnchors = getNodeFigure().getSourceConnectionAnchors();
				for (int i=0; i<sourceAnchors.size(); i++) {
					ConnectionAnchor anchor = (ConnectionAnchor)sourceAnchors.get(i);
					list.add(anchor.getReferencePoint().getTranslated(0, 3));
				}
				return list;
			}

		};
	return super.getAdapter(key);
}

/**
 * 
 * @return The current model 
 */
private ClassDiagramModel getClassDiagramModel(){
	System.out.println("ClassEditpart getModel");
	return (ClassDiagramModel)getModel();
}

/**
 * Helper function to perform direct edit
 *
 */
private void performDirectEdit(){
	System.out.println("ClassEditpart performDirectEdit");
	if(manager == null)
		manager = new LogicLabelEditManager(this, 
			TextCellEditor.class, new LabelCellEditorLocator((ClassFigure)getFigure()));
	manager.show();
}

/**
 * When a request is created manage it.We only handle direct edit
 * request
 */
public void performRequest(Request request){
	System.out.println("ClassEditpart performRequest");
	if (request.getType() == RequestConstants.REQ_DIRECT_EDIT)
		performDirectEdit();
}

/**
 * Handle property Change.We only handle name change rest handled 
 * by the superclass
 */
public void propertyChange(PropertyChangeEvent evt){
	if (evt.getPropertyName().equalsIgnoreCase("Name"))//$NON-NLS-1$
		manageNameChange((String)evt.getOldValue(),(String)evt.getNewValue());
	else if(evt.getPropertyName().equalsIgnoreCase("color"))
		refreshVisuals();
	else
		//If the property is an Input property ,
		//we need to edit the java file to include a 
		//field to the class with the name of the target.
		//So set the source file to change.
		//set the target filename to be added as a string
		//edit the source file.
		super.propertyChange(evt);
}
/**
 * Set the new name to the object
 */
protected void refreshVisuals() {
	try{
	((ClassFigure)getFigure()).setText(getClassDiagramModel().getName());
	if(getClassDiagramModel().isSelected())
		((ClassFigure)getFigure()).setForegroundColor(dead);
	else
		((ClassFigure)getFigure()).setForegroundColor(alive);
	
	super.refreshVisuals();
	}
	catch(Exception e){
		e.printStackTrace();
	}
}

/**
 * replace the class name and refresh visuals
 * @param oldName
 * @param newName
 */
private void manageNameChange(String oldName, String newName){
	//We need to change the name of the Class file Created
	ResourceMgtUtils.renameFile(oldName,newName);
	refreshVisuals();
}
}