package APStudio;

import java.util.ArrayList;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.gef.palette.CombinedTemplateCreationEntry;
import org.eclipse.gef.palette.MarqueeToolEntry;
import org.eclipse.gef.palette.PaletteContainer;
import org.eclipse.gef.palette.PaletteDrawer;
import org.eclipse.gef.palette.PaletteGroup;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.palette.PaletteSeparator;
import org.eclipse.gef.palette.SelectionToolEntry;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.gef.requests.SimpleFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;

import APStudio.models.ClassDiagramModel;
import APStudio.models.ClassGraphModel;
/**
 * The main plugin class to be used in the desktop.
 */
public class APStudioPlugin extends AbstractUIPlugin {
	//The shared instance.
	private static APStudioPlugin plugin;
	//Resource bundle.
	private ResourceBundle resourceBundle;
	/**
	 * The currently selected project
	 */
	private static IProject currentProject;
	
	/**
	 * The constructor.
	 */
	public APStudioPlugin(IPluginDescriptor descriptor) {
		super(descriptor);
		plugin = this;
//		try {
//			resourceBundle= ResourceBundle.getBundle("APStudio.APStudioPluginResources");
//		} catch (MissingResourceException x) {
//			resourceBundle = null;
//		}
	}

	/**
	 * Returns the shared instance.
	 */
	public static APStudioPlugin getDefault() {
		return plugin;
	}

	/**
	 * Returns the workspace instance.
	 */
	public static IWorkspace getWorkspace() {
		return ResourcesPlugin.getWorkspace();
	}

	/**
	 * Returns the string from the plugin's resource bundle,
	 * or 'key' if not found.
	 */
	public static String getResourceString(String key) {
		ResourceBundle bundle= APStudioPlugin.getDefault().getResourceBundle();
		try {
			return bundle.getString(key);
		} catch (MissingResourceException e) {
			return key;
		}
	}

	/**
	 * Returns the plugin's resource bundle,
	 */
	public ResourceBundle getResourceBundle() {
		return resourceBundle;
	}

	/**
	 * set the current project - called by the builder when we're about to
	 * do a build.
	 */
	public void setCurrentProject(IProject project) {
		currentProject = project;
	}
	


	static private List createCategories(PaletteRoot root){
		List categories = new ArrayList();
	
		categories.add(createControlGroup(root));
		categories.add(createComponentsDrawer());
//		categories.add(createComplexPartsDrawer());
//		categories.add(createTemplateComponentsDrawer());
//		categories.add(createComplexTemplatePartsDrawer());

		return categories;
	}
	
	static private PaletteContainer createControlGroup(PaletteRoot root){
		PaletteGroup controlGroup = new PaletteGroup(
			"ControlGroup");

		List entries = new ArrayList();

		ToolEntry tool = new SelectionToolEntry();
		entries.add(tool);
		root.setDefaultEntry(tool);

		tool = new MarqueeToolEntry();
		entries.add(tool);
	
		PaletteSeparator sep = new PaletteSeparator(
				"org.eclipse.gef.examples.logicdesigner.logicplugin.sep2"); //$NON-NLS-1$
		sep.setUserModificationPermission(sep.PERMISSION_NO_MODIFICATION);
		entries.add(sep); //$NON-NLS-1$

		tool = new CConnectionCreationToolEntry(
			"Construction Edge",
			"Helps create a construction edge between two classes",
			null,
			ImageDescriptor.createFromFile(ClassGraphModel.class, "icons/connection16.gif"),//$NON-NLS-1$
			ImageDescriptor.createFromFile(ClassGraphModel.class, "icons/connection24.gif")//$NON-NLS-1$
		);
		entries.add(tool);

		tool = new IConnectionCreationToolEntry(
			"Inheritance Edge",
			"Helps create a Alternation edge between two classes",
			null,
			ImageDescriptor.createFromFile(ClassGraphModel.class, "icons/connection16.gif"),//$NON-NLS-1$
			ImageDescriptor.createFromFile(ClassGraphModel.class, "icons/connection24.gif")//$NON-NLS-1$
		);
		entries.add(tool);

		controlGroup.addAll(entries);
		return controlGroup;
	}	
	
	static private PaletteContainer createComponentsDrawer(){

		PaletteDrawer drawer = new PaletteDrawer(
			"Components",
			ImageDescriptor.createFromFile(ClassGraphModel.class, "icons/comp.gif"));//$NON-NLS-1$

		List entries = new ArrayList();
	
	
		CombinedTemplateCreationEntry combined = new CombinedTemplateCreationEntry(
			"Class",
			"Create a class",
			"Class Template",
			new SimpleFactory(ClassDiagramModel.class),
			ImageDescriptor.createFromFile(ClassGraphModel.class, "icons/label16.gif"), //$NON-NLS-1$
			ImageDescriptor.createFromFile(ClassGraphModel.class, "icons/label24.gif")//$NON-NLS-1$
		);
		entries.add(combined);

		drawer.addAll(entries);
		return drawer;
	}
			
	public static PaletteRoot createPalette() {
		PaletteRoot logicPalette = new PaletteRoot();
		logicPalette.addAll(createCategories(logicPalette));
		return logicPalette;
	}
	
	/**
		 * get the current project, if nobody has set a project yet, use the
		 * first project in the workspace
		 */
		public static IProject getCurrentProject() {
			IProject current;
			if (currentProject != null) {
				current = currentProject;
			} else {
				IProject[] projects = getWorkspace().getRoot().getProjects();
				if (projects.length > 0) {
					current = projects[0];
				} else {
					current = null;
				}
			}
			return current;
		}

}
