package com.ibm.lab.jdt;

import java.util.*;
import org.eclipse.jdt.core.*;

public class JavaMetrics {
	private int methodDeclarationCount;
	private int fieldDeclarationCount;
	private int stringLiteralCount;
	private ICompilationUnit cu;
	private List listeners = new ArrayList();

	public JavaMetrics() {
		this.reset(null);
	}

	public void reset(ICompilationUnit newcu) {
		cu = newcu;

		methodDeclarationCount = 0;
		fieldDeclarationCount = 0;
		stringLiteralCount = 0;

//		insert code here

		notifyListeners();
	}

	public void addListener(IJavaMetricsListener listener) {
		listeners.add(listener);
//		insert code here
	}

	public void removeListener(IJavaMetricsListener listener) {
		listeners.remove(listener);
//		insert code here
	}
	
	private IJavaElementDelta findJavaElementDelta(
		IJavaElementDelta parentJed,
		IJavaElement je) {
			
		IJavaElementDelta jed = parentJed;
		IJavaElement je2 = parentJed.getElement();
		
		if (je2 instanceof IWorkingCopy && ((IWorkingCopy) je2).isWorkingCopy())
			je2 = ((IWorkingCopy) je2).getOriginalElement();
		
		if (je.equals(je2)) {
			return parentJed;
		} else {
			for (int i = 0; i < parentJed.getAffectedChildren().length; i++) {
				jed = findJavaElementDelta(parentJed.getAffectedChildren()[i], je);
				if (jed != null)
					return jed;
			}
		}

		return null;
	}

	private void notifyListeners() {
		for (Iterator iterator = listeners.iterator(); iterator.hasNext();) {
			IJavaMetricsListener listener = (IJavaMetricsListener) iterator.next();
			listener.refresh(this);
		}
	}

	public int getMethodDeclarationCount() {
		return methodDeclarationCount;
	}

	public int getFieldDeclarationCount() {
		return fieldDeclarationCount;
	}

	public int getStringLiteralCount() {
		return stringLiteralCount;
	}

	public String summaryString() {
		StringBuffer sb = new StringBuffer();

		sb.append("# Methods = " + getMethodDeclarationCount() + "\n");
		sb.append("# Fields = " + getFieldDeclarationCount() + "\n");
		sb.append("# String Literals = " + getStringLiteralCount() + "\n");

		return sb.toString();
	}

	public boolean hasValidMetrics() {
		return cu != null;
	}
}