package com.ibm.lab.soln.usingjdt.quickfix;

/*
 * "The Java Developer's Guide to Eclipse"
 *   by Shavor, D'Anjou, Fairbrother, Kehn, Kellerman, McCarthy
 * 
 * (C) Copyright International Business Machines Corporation, 2003. 
 * All Rights Reserved.
 * 
 * Code or samples provided herein are provided without warranty of any kind.
 */

import java.util.ArrayList;

/**
 * Class <code>PrimeNumberGenerator</code> generates a series of prime numbers
 * starting with 2. The class is used in a number of the exercises in Chapters
 * 29 and 30 to illustrate different capabilities of the Java Development Tools
 * (JDT). Several versions of this class exist in different packages in this
 * project and in packages in other projects. These different versions are used
 * in the different parts of the exercises in chapters 29 and 30.
 */
public class PrimeNumberGenerator {
	
	/** 
	 * Field <code>quan</code> is the number of prime numbers to generate, starting
	 * with 2. 
	 */
	public int quan;

	/**
	 * Field <code>results</code> contains the generated prime numbers.
	 */
	private Object[] results;

	/**
	 * Method <code>generatePrimeNumbers</code> generates <code>quan</code> 
	 * prime numbers.
	 */
	public void generatePrimeNumbers() {
		int count = 0;
		ArrayList numbers = new ArrayList();
		boolean prime;
		int n = 2;
		while (count < quan) {
			prime = true;
			int factor = 2;
			while (factor <= n / factor && prime) {		
				if (n % factor == 0) {
					prime = false;
				} else {
					factor++;
				}
			}
			if (prime) {
				numbers.add(new Integer(n));
				count++;
			}
			n++;
		}
		numbers.trimToSize();
		setResults(numbers.toArray());
	}


	/**
	 * Method <code>getResults</code> returns the generated prime numbers.
	 * @return Object[]
	 */
	public Object[] getResults() {
		return results;
	}

	/**
	 * Method <code>setResults</code> sets generated prime numbers.
	 * @param results Array of generated prime numbers
	 */
	public void setResults(Object[] results) {
		this.results = results;
	}

}
