package com.ibm.lab.msseditor.ui.actions;

/*
 * "The Java Developer's Guide to Eclipse"
 *   by Shavor, D'Anjou, Fairbrother, Kehn, Kellerman, McCarthy
 * 
 * (C) Copyright International Business Machines Corporation, 2003. 
 * All Rights Reserved.
 * 
 * Code or samples provided herein are provided without warranty of any kind.
 */

import java.text.MessageFormat;

import org.eclipse.jface.dialogs.MessageDialog;

/**
 * Action to display the sum of all integer cells of the mini-spreadsheet.
 */
public class ShowTotalAction extends MiniSpreadsheetEditorAction {

	public ShowTotalAction() {
		super();

		this.setText("Show &Total");
		this.setId("#ShowTotal");
	}

	/**
	 * @see org.eclipse.jface.action.IAction#run()
	 */
	public void run() {
		int total = getMiniSpreadsheet().getTotal();
		MessageDialog.openInformation(
			null, "Show Total",
			MessageFormat.format("Total: {0}", new Object[] {Integer.toString(total)}));
	}
}
