package com.ibm.lab.usingjdt.refactoring;

/*
 * "The Java Developer's Guide to Eclipse"
 *   by Shavor, D'Anjou, Fairbrother, Kehn, Kellerman, McCarthy
 * 
 * (C) Copyright International Business Machines Corporation, 2003. 
 * All Rights Reserved.
 * 
 * Code or samples provided herein are provided without warranty of any kind.
 */

import java.util.ArrayList;
import java.util.Date;
import java.util.Comparator;
import java.util.Arrays;

/**
 * Class <code>PrimeNumberGenerator</code> generates a series of prime numbers
 * starting with 2. The class is used in a number of the exercises in Chapters
 * 29 and 30 to illustrate different capabilities of the Java Development Tools
 * (JDT). Several versions of this class exist in different packages in this
 * project and in packages in other projects. These different versions are used
 * in the different parts of the exercises in chapters 29 and 30.
 */
public class PrimeNumberGenerator {

	/** 
	 * Field <code>quan</code> is the number of prime numbers to generate, starting
	 * with 2. 
	 */
	public int quan;

	/**
	 * Field <code>results</code> contains the generated prime numbers.
	 */
	private Object[] results;

	/**
	 * Method <code>generatePrimeNumbers</code> generates <code>quan</code> 
	 * prime numbers.
	 */
	public void generatePrimeNumbers() {
		int count = 0;
		ArrayList numbers = new ArrayList();
		boolean prime;
		int n = 2;
		while (count < quan) {
			prime = true;
			int factor = 2;
			while (factor <= n / factor && prime) {		
				if (n % factor == 0) {
					prime = false;
				} else {
					factor++;
				}
			}
			if (prime) {
				numbers.add(new Integer(n));
				count++;
			}
			n++;
		}
		numbers.trimToSize();
		setResults(numbers.toArray());
	}

	/**
	 * Method <code>outputResults </code> outputs the generated prime numbers.
	 * @param prefix String added to the front of each line of output. Used
	 * to distinguish output from different threads.
	 */
	public void outputResults(String prefix) {
		Date d = new Date();
		System.out.println(prefix + d.toString());
		for (int i = 0; i < getResults().length; i++) {
			System.out.println(prefix + getResults()[i]);
		}
	}
	
	/**
	 * Method <code>sortResults</code> sorts the prime numbers in reverse order.
	 * The example may seem a bit contrived. It is included to demonstrate generating
	 * inner classes.
	 */
	public void sortResults() {
		Arrays.sort(getResults(),
		new Comparator() { 
			/**
			 * @see java.util.Comparator#compare(Object, Object)
		 	*/
			public int compare(Object arg0, Object arg1) {
				if (((Integer) arg0).intValue() < ((Integer) arg1).intValue()) {
					return 1;
				} else {
					return -1;
				}
			}
		});
	}

	/**
	 * Method <code>getResults</code> returns the generated prime numbers.
	 * @return Object[]
	 */
	public Object[] getResults() {
		return results;
	}

	/**
	 * Method <code>setResults</code> sets generated prime numbers.
	 * @param results Array of generated prime numbers
	 */
	public void setResults(Object[] results) {
		this.results = results;
	}

}
